/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.pot;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.ItemFall;
import dangeon.model.map.MapList;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.check.Checker;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Enchant;
import dangeon.util.R;
import dangeon.util.STAGE;
import dangeon.view.detail.View_Sider;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import main.res.Image_Artifact;
import main.res.SE;

public abstract class Base_Pot
extends Base_Item {
    private static final long serialVersionUID = 1L;
    public ENCHANT_SIMBOL simbol = null;
    private final List<STAGE> stages;
    protected int MAX;
    protected final ArrayList<Base_Artifact> LIST;

    public Base_Pot(Point p, String item_name, int max, STAGE ... stages) {
        super(p, item_name, 0, Base_Artifact.ITEM_CASE.ETC);
        this.IM = Image_Artifact.BIN;
        this.MAX = max;
        this.LIST = new ArrayList(this.MAX);
        this.stages = new ArrayList<STAGE>();
        STAGE[] sTAGEArray = stages;
        int n = stages.length;
        int n2 = 0;
        while (n2 < n) {
            STAGE stage = sTAGEArray[n2];
            this.stages.add(stage);
            ++n2;
        }
    }

    public void addMax() {
        if (this.MAX < 4) {
            ++this.MAX;
        }
    }

    public boolean broken() {
        SE.BROKEN.play();
        Iterator<Base_Artifact> iterator = this.LIST.iterator();
        while (iterator.hasNext()) {
            ItemFall.itemFall(this.mass_point, iterator.next());
        }
        return true;
    }

    protected boolean emptyAction() {
        Message.set(this.getColoredName(), "\u306f\u304b\u3089\u3063\u307d\u3060\uff01");
        if (!this.isStaticCheked()) {
            Checker.write(this, Checker.KeyWord.\u4f7f\u7528);
        }
        return false;
    }

    @Override
    protected int enchantDefence(boolean b, Base_Creature creature, int damage) {
        return 0;
    }

    @Override
    public void firstMsgAtUsingThis() {
    }

    @Override
    protected final String[] getExplan() {
        if (this.LIST.isEmpty()) {
            return super.getExplan();
        }
        String[] arr = new String[this.LIST.size()];
        int i = 0;
        while (i < this.LIST.size()) {
            StringBuilder sb = new StringBuilder();
            if (i == 0) {
                sb.append("\u3010\u4e2d\u8eab\u3011");
            } else {
                sb.append("\u3000\u3000\u3000\u3000");
            }
            Base_Artifact a = this.LIST.get(i);
            sb.append(a.getColoredName());
            arr[i] = sb.toString();
            ++i;
        }
        return arr;
    }

    @Override
    public String getLastPackage() {
        return "pot";
    }

    public int getListSize() {
        return this.LIST.size();
    }

    public List<STAGE> getListStage() {
        return this.stages;
    }

    public int getMaxSize() {
        return this.MAX;
    }

    @Override
    public StringBuilder getName(StringBuilder sb) {
        if (this.isStaticCheked()) {
            sb.append(this.getName());
            sb.append("[");
            sb.append(this.MAX - this.LIST.size());
            sb.append("]");
        } else {
            String name = this.getName();
            Matcher m = Pattern.compile("\u300a.*?\u300b").matcher(name);
            if (m.find()) {
                String sub = m.group();
                sb.append(m.replaceAll(""));
                sb.append("[");
                sb.append(this.MAX - this.LIST.size());
                sb.append("]");
                sb.append(sub);
            } else {
                sb.append(this.getName());
                sb.append("[");
                sb.append(this.MAX - this.LIST.size());
                sb.append("]");
            }
        }
        return sb;
    }

    @Override
    public int getShadow() {
        return 3;
    }

    public String[] getSuperExplain() {
        return super.getExplan();
    }

    public boolean isEmpty() {
        return this.LIST.isEmpty();
    }

    public boolean isMax() {
        return this.LIST.size() == this.MAX;
    }

    protected boolean isUnableToPutIn(Base_Artifact a) {
        if (Enchant.isEnchanted(a) && a.isCurse()) {
            return true;
        }
        if (!a.isMobile()) {
            return true;
        }
        return a instanceof Base_Pot;
    }

    @Override
    public int itemEnchantPower(Base_Artifact.STATUS status) {
        return 0;
    }

    @Override
    public void setMassPoint_ParabolaJump_NoAttack_PotBreak(Point p) {
        super.setMassPoint_ParabolaJump_NoAttack_PotBreak(p);
        if (new R().is(12)) {
            final Base_Pot af = this;
            this.at_movement_end_task = new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    if (Base_Pot.this.getListComposition().contains((Object)ENCHANT_SIMBOL.\u91d1)) {
                        Base_Pot.this.getListComposition().remove((Object)ENCHANT_SIMBOL.\u91d1);
                        Message.set(Base_Pot.this.getColoredName(), "\u306e\u795e\u306e\u52a0\u8b77\u304c\u5265\u304c\u308c\u305f@");
                    } else if (Base_Pot.this.broken()) {
                        Message.set("\u8ee2\u3093\u3060\u885d\u6483\u3067\u74f6\u304c\u5272\u308c\u3066\u3057\u307e\u3063\u305f");
                        View_Sider.setInformation(Base_Pot.this.getColoredName(), "\u306f\u58ca\u308c\u3066\u3057\u307e\u3063\u305f");
                        MapList.removeArtifact(af);
                    }
                }
            };
        }
    }

    public void setMax(int i) {
        this.MAX = i;
    }
}

