/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.arrow;

import dangeon.controller.TaskOnMapObject;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.arrow.\u30df\u30cb\u516b\u5366\u7089;
import dangeon.model.object.artifact.item.arrow.\u5927\u7832\u306e\u5f3e;
import dangeon.model.object.artifact.item.arrow.\u6bd2\u30ca\u30a4\u30d5;
import dangeon.model.object.artifact.item.arrow.\u9244\u306e\u77e2;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Player;
import dangeon.util.Damage;
import dangeon.util.R;
import java.awt.Point;
import java.util.Random;
import main.res.SE;
import main.util.DIRECTION;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public abstract class Arrow
extends Base_Item {
    private static final long serialVersionUID = 1L;
    private int arrow_rest;

    protected Arrow(Point p, String item_name, boolean natural) {
        super(p, item_name, 0, Base_Artifact.ITEM_CASE.ARROW);
        if (natural) {
            R ran = new R();
            if (this instanceof \u5927\u7832\u306e\u5f3e) {
                this.setArrowRest(((Random)ran).nextInt(3) + 3);
            } else if (this instanceof \u30df\u30cb\u516b\u5366\u7089) {
                this.setArrowRest(((Random)ran).nextInt(3) + 3);
            } else if (this instanceof \u6bd2\u30ca\u30a4\u30d5) {
                this.setArrowRest(((Random)ran).nextInt(6) + 3);
            } else if (this instanceof \u9244\u306e\u77e2) {
                this.setArrowRest(((Random)ran).nextInt(6) + 10);
            }
        } else {
            this.setArrowRest(1);
        }
    }

    public Arrow(Point p, String item_name, int num) {
        super(p, item_name, 0, Base_Artifact.ITEM_CASE.ARROW);
        this.setArrowRest(num);
    }

    @Override
    protected void action() {
    }

    public void addArrowRest(int delt) {
        this.arrow_rest += delt;
    }

    protected int arrowStr() {
        return 0;
    }

    public Base_Artifact createArrowRest(int delt) {
        this.arrow_rest += delt;
        return this;
    }

    protected int enchantAttack(boolean normal, Base_Creature c, int damage) {
        return damage;
    }

    @Override
    protected int enchantDefence(boolean normal, Base_Creature c, int damage) {
        return damage;
    }

    @Override
    public Boolean exchange() {
        Arrow arr = Belongings.getArrow(this.getClass());
        if (arr == null) {
            return false;
        }
        if (arr.getArrowRest() == 99) {
            Message.set(this.getColoredName().concat("\u306f\u3046\u307e\u304f\u307e\u3068\u3081\u3089\u308c\u306a\u304b\u3063\u305f"));
            return true;
        }
        this.matomeru(arr, this.getColoredName().concat("\u3092\u62fe\u3063\u3066\u307e\u3068\u3081\u305f"));
        return null;
    }

    @Override
    public void firstMsgAtUsingThis() {
    }

    public int getArrowRest() {
        return this.arrow_rest;
    }

    public String getExplainationInShortCutSelecting() {
        return "";
    }

    @Override
    public String getLastPackage() {
        return "arrow";
    }

    @Override
    public int getMerchantSoldValue() {
        int i = this.arrow_rest * this.base_merchant_value / this.getMin();
        if (i < 1) {
            i = 0;
        }
        return i;
    }

    private int getMin() {
        if (this instanceof \u9244\u306e\u77e2) {
            return 10;
        }
        return 3;
    }

    @Override
    public StringBuilder getName(StringBuilder sb) {
        if (this.scale() != null && this.getArrowRest() > 0) {
            sb.append(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(this.getArrowRest()));
            sb.append(this.scale());
            sb.append("\u306e");
        }
        sb.append(this.getName());
        return sb;
    }

    public abstract Arrow getOne();

    @Override
    protected String getSecondExplain_ByCategory() {
        return "\u300c\u5c04\u6483\u300d\u3067\u30bb\u30c3\u30c8\u3057\u3066\u300c\uff26\u300d\u30ad\u30fc\u3067\u6295\u3052\u3088\u3046\u3002\u30a2\u30a4\u30c6\u30e0\u30b3\u30de\u30f3\u30c9\u304b\u3089\u300c\u6295\u3052\u300d\u3092\u9078\u629e\u3059\u308b\u3068\u675f\u306d\u305f\u3082\u306e\u3092\u5168\u3066\u6295\u3052\u308b\u3002\u5c04\u6483\u7269\u306f\u546a\u308f\u308c\u3066\u3082\u5e73\u6c17\u3002";
    }

    @Override
    public int getShadow() {
        return 9;
    }

    @Override
    public boolean isAbleToCurse() {
        return false;
    }

    @Override
    public boolean isParmitThisItemFreeze() {
        return false;
    }

    @Override
    public void itemHit(Base_Creature deffece, Base_Creature attack) {
        if (attack instanceof Base_Enemy) {
            Damage.EtoPandE_ArrowAttack(this.getName().concat("\u3092\u53d7\u3051\u3066\u5012\u308c\u305f"), this.getName(), attack, deffece);
        } else {
            int str = this.arrowStr();
            if (this.getArrowRest() != 1) {
                str = (int)((double)str * 0.8 * (double)this.getArrowRest());
            }
            Damage.PtoE_ArrowAttack(this, attack, deffece, str);
        }
    }

    @Override
    public boolean itemPickUp() {
        Arrow arr = Belongings.getArrow(this.getClass());
        if (arr == null) {
            super.itemPickUp();
        } else if (arr.getArrowRest() == 99) {
            Message.set(this.getColoredName().concat("\u306f\u3046\u307e\u304f\u307e\u3068\u3081\u3089\u308c\u306a\u304b\u3063\u305f"));
        } else {
            this.matomeru(arr, this.getColoredName().concat("\u3092\u62fe\u3063\u3066\u307e\u3068\u3081\u305f"));
        }
        return false;
    }

    @Override
    public boolean itemUse() {
        DIRECTION d = Player.me.getDirection();
        Arrow a = this.arrow_rest > 1 ? this.getOne() : this;
        Player.me.itemThrow(a, d);
        Message.set("\u30c1\u30eb\u30ce\u306f", ((Base_MapObject)a).getColoredName(), "\u3092\u6295\u3052\u305f");
        return true;
    }

    private void matomeru(Arrow arr, String str) {
        arr.setArrowRest(arr.getArrowRest() + this.getArrowRest());
        if (arr.getArrowRest() > 99) {
            arr.setArrowRest(99);
        }
        TaskOnMapObject.addTrapRemoveTask(this);
        Message.set(str);
        SE.SYSTEM_PICKUP.play();
    }

    protected abstract String scale();

    public Arrow setArrowRest(int value) {
        this.arrow_rest = value;
        return this;
    }

    public int takeIt() {
        Arrow arr = Belongings.getArrow(this.getClass());
        if (arr != null) {
            if (arr.getArrowRest() == 99) {
                Message.set(this.getColoredName().concat("\u306f\u65e2\u306b\u3044\u3063\u3071\u3044\u3067\u53d6\u308a\u51fa\u305b\u306a\u3044"));
                return -1;
            }
            this.matomeru(arr, this.getColoredName().concat("\u3092\u53d6\u308a\u51fa\u3057\u3066\u307e\u3068\u3081\u305f"));
            return 1;
        }
        return 0;
    }
}

