/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.device;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.task.Task;
import dangeon.model.map.MassCreater;
import dangeon.model.map.field.Base_Map;
import dangeon.model.object.artifact.device.HiddenDevice;
import dangeon.model.object.creature.player.Player;
import java.awt.Point;
import main.res.Image_Artifact;
import main.util.BlackOut;
import main.util.DIRECTION;

public class HiddenMovePoint
extends HiddenDevice {
    private static final long serialVersionUID = 1L;
    private final Base_Map BFM;
    private final Point PLAYER;
    private final DIRECTION D;
    private Point walk = null;

    public HiddenMovePoint(int x, int y, Base_Map bfm, DIRECTION d) {
        super(new Point(x, y));
        this.IM = Image_Artifact.STAIRS;
        this.BFM = bfm;
        this.PLAYER = bfm.getEntrancePoint();
        this.D = d;
    }

    public HiddenMovePoint(int x, int y, Base_Map bfm, Point player, DIRECTION d) {
        super(new Point(x, y));
        this.IM = Image_Artifact.STAIRS;
        this.BFM = bfm;
        this.PLAYER = player;
        this.D = d;
    }

    private void effect() {
        new BlackOut(this.BFM, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                TaskOnMapObject.setNewMap(new MassCreater(HiddenMovePoint.this.BFM, HiddenMovePoint.this.PLAYER, false));
                Player.me.setDirection(HiddenMovePoint.this.D);
            }
        });
    }

    public HiddenMovePoint setMovePoint(Point p) {
        this.walk = p;
        return this;
    }

    @Override
    public boolean walkOnAction() {
        if (this.walk == null) {
            this.effect();
        } else {
            Player.me.setMassPoint_WalkLike(this.walk, 1, new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    HiddenMovePoint.this.effect();
                }
            });
        }
        return true;
    }
}

