/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.ThrowingItem;
import dangeon.controller.task.Task;
import dangeon.latest.scene.Base_View;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.latest.scene.action.message.Message;
import dangeon.latest.system.KeyHolder;
import dangeon.model.condition.CONDITION;
import dangeon.model.config.table.ItemDetail;
import dangeon.model.map.ItemFall;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.device.Base_Device;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.arrow.\u30df\u30cb\u516b\u5366\u7089;
import dangeon.model.object.artifact.item.check.Checker;
import dangeon.model.object.artifact.item.enchantSpecial.Composition;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u90aa;
import dangeon.model.object.artifact.item.pot.Base_Pot;
import dangeon.model.object.artifact.item.scrool.Scrool;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.artifact.item.staff.Staff;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.class_job.bonus.bonus_switch.BonusConductor;
import dangeon.util.Damage;
import dangeon.util.ObjectPoint;
import dangeon.util.R;
import dangeon.view.util.WithinOutofScreen;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import main.res.Image_Artifact;
import main.res.SE;
import main.util.CSVLoadSupporter;
import main.util.DIRECTION;

public abstract class Base_Artifact
extends Base_MapObject
implements Comparable<Base_Artifact> {
    private static final long serialVersionUID = 1L;
    protected Image_Artifact IM = Image_Artifact.NULL;
    protected boolean mobile;
    public int composition_number;
    public final List<Base_Artifact> compositon;
    protected int item_freeze_count = 0;
    protected boolean flag_no_frozen = false;
    public int pick_count = 0;
    protected boolean visible = false;
    protected int forge_value = 0;
    public int staff_rest = 0;
    private boolean curse = false;
    private final ITEM_CASE ITEM_CASE;
    protected int item_exp = 0;
    Mass[][] mass = MassCreater.getMass();
    public ENCHANT_SIMBOL sim;
    private List<ENCHANT_SIMBOL> list_composition = new ArrayList<ENCHANT_SIMBOL>();
    private boolean checked_static = false;
    protected String[] exn;
    public boolean flag_sample;
    public boolean flag_unknown;
    protected boolean flag_punishment = false;
    protected boolean flag_merchant;
    protected boolean flag_pass_turn;
    private boolean flag_hatate;

    public static void exchange(Base_Artifact pickUp, Base_Artifact a) {
        Base_Artifact.exchange(pickUp, Belongings.getListItems().indexOf(a));
    }

    public static void exchange(Base_Artifact pickUp, int setOn) {
        Message.set(pickUp.getColoredName().concat("\u3092\u62fe\u3063\u3066"));
        Base_Artifact a = Belongings.get(setOn);
        if (Belongings.pickUpItem(pickUp, setOn)) {
            pickUp.setMassPoint(new Point(-1, -1));
            TaskOnMapObject.addTrapRemoveTask(pickUp);
        }
        a.itemSetOn();
    }

    protected Base_Artifact(Point p, String name, int composition_number, ITEM_CASE item_case, boolean mobile) {
        super(name, p, 1);
        this.mobile = mobile;
        this.composition_number = composition_number;
        this.compositon = new ArrayList<Base_Artifact>(composition_number);
        this.ITEM_CASE = item_case;
        this.init();
    }

    public void addListComposition(ENCHANT_SIMBOL ec) {
        if (this.list_composition.size() >= this.composition_number) {
            return;
        }
        if (!this.list_composition.contains((Object)ec) && this.sim != ec) {
            this.list_composition.add(ec);
        }
    }

    public void changeToGolden() {
    }

    public void check() {
        Checker.checkStatic(this);
    }

    public void check(String s) {
    }

    @Override
    public int compareTo(Base_Artifact o) {
        if (this.getClassName().equals(o.getClassName())) {
            return 0;
        }
        return 1;
    }

    public boolean compositionSpace() {
        return this.list_composition.size() < this.composition_number;
    }

    public Base_Artifact createItemCheck() {
        if (this instanceof Base_Item) {
            ((Base_Item)this).check();
        }
        return this;
    }

    public Base_Artifact createSpellCard(boolean CURSE, int FORGE_VALUE) {
        this.check();
        this.curse = CURSE;
        this.forge_value = FORGE_VALUE;
        return this;
    }

    public Base_Artifact createSpellCard(boolean CURSE, int FORGE_VALUE, ENCHANT_SIMBOL ... SIMBOL) {
        this.curse = CURSE;
        this.forge_value = FORGE_VALUE;
        if (SIMBOL != null) {
            ENCHANT_SIMBOL[] eNCHANT_SIMBOLArray = SIMBOL;
            int n = SIMBOL.length;
            int n2 = 0;
            while (n2 < n) {
                ENCHANT_SIMBOL ec = eNCHANT_SIMBOLArray[n2];
                this.list_composition.add(ec);
                ++n2;
            }
        }
        return this;
    }

    public Base_Artifact createStaffRest(int i) {
        if (this instanceof Staff) {
            this.check();
            this.staff_rest = i;
        }
        return this;
    }

    public Base_Artifact defaultCurse() {
        int select = new R().nextInt(16);
        if (select == 0) {
            this.curse = this.isAbleToCurse();
        }
        return this;
    }

    public void doWhenPickuped() {
        this.endJump();
        if (EnchantSpecial.enchantSimbolAllCheck(ENCHANT_SIMBOL.\u8b58\u5225)) {
            this.check();
        }
    }

    public void enchant() {
        Checker.enchant(this);
    }

    public void enchantCheck(boolean no_tokidoki_check) {
        if (!(this.sim == null || this.isStaticCheked() || !no_tokidoki_check && this.sim.tokidoki)) {
            String s = this.getColoredName();
            Checker.checkStatic(this);
            Message.set(s, "\u306f", this.getColoredName(), "\u3060\u3063\u305f");
            SE.CHECK.play();
        }
    }

    protected abstract int enchantDefence(boolean var1, Base_Creature var2, int var3);

    public void endPlayerTurn() {
    }

    public Boolean exchange() {
        return false;
    }

    public final String[] firstPageExplain() {
        if (this.flag_unknown) {
            String c = Color.LIGHT_GRAY.toString();
            return new String[]{String.valueOf(c) + "\u307e\u3060\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093", String.valueOf(c) + "\u62fe\u3063\u305f\u3060\u3051\u3067\u306f\u767b\u9332\u3055\u308c\u305a\u3001\u4f7f\u7528\u3059\u308b\u3053\u3068\u3067\u767b\u9332\u3055\u308c\u307e\u3059"};
        }
        if (!this.isStaticCheked() && !this.flag_sample) {
            String c = Color.LIGHT_GRAY.toString();
            if (this instanceof SpellCard) {
                return new String[]{String.valueOf(c) + "\u672a\u8b58\u5225\u306e\u305f\u3081\u4f55\u306e\u30ab\u30fc\u30c9\u304b\u3088\u304f\u5206\u304b\u308a\u307e\u305b\u3093", String.valueOf(c) + "\u4f7f\u7528\u3059\u308b\u3053\u3068\u3067\u8b58\u5225\u3055\u308c\u307e\u3059", String.valueOf(Color.MAGENTA.toString()) + "\u88c5\u5099\u3059\u308b\u3060\u3051\u3067\u3082\u8b58\u5225\u3055\u308c\u307e\u3059", String.valueOf(Base_Item.CL_CURSED.toString()) + "\u546a\u308f\u308c\u3066\u3044\u308b\u3053\u3068\u304c\u3042\u308b\u306e\u3067\u6ce8\u610f\u3057\u3066\u4e0b\u3055\u3044"};
            }
            if (!(this instanceof Base_Pot) || ((Base_Pot)this).isEmpty()) {
                return new String[]{String.valueOf(c) + "\u672a\u8b58\u5225\u306e\u305f\u3081\u3088\u304f\u5206\u304b\u308a\u307e\u305b\u3093", String.valueOf(c) + "\u4f7f\u7528\u3059\u308b\u3053\u3068\u3067\u8b58\u5225\u3055\u308c\u307e\u3059", String.valueOf(c) + "\u88c5\u5099\u3057\u3066\u79d8\u3081\u3089\u308c\u305f\u5370\u306e\u52b9\u679c\u304c\u767a\u63ee\u3057\u3066\u3082\u8b58\u5225\u3055\u308c\u307e\u3059"};
            }
        }
        String[] ITEM_EXPLAN = new String[4];
        if (this instanceof SpellCard) {
            String[] arr = this.getExplan();
            if (arr.length == 1) {
                ITEM_EXPLAN[0] = arr[0];
                ITEM_EXPLAN[1] = "";
            } else {
                ITEM_EXPLAN[0] = arr[0];
                ITEM_EXPLAN[1] = arr[1];
            }
            ITEM_EXPLAN[2] = ((SpellCard)this).getSpellStatus();
            ITEM_EXPLAN[3] = Composition.composition(this);
        } else {
            String[] arr = this.getExplan();
            int i = 0;
            while (i < ITEM_EXPLAN.length) {
                ITEM_EXPLAN[i] = arr == null || arr.length <= i ? "" : arr[i];
                ++i;
            }
        }
        return ITEM_EXPLAN;
    }

    protected String flavorExplain() {
        return "\u300c\u30d5\u30ec\u30fc\u30d0\u30fc\u30c6\u30ad\u30b9\u30c8\u300d";
    }

    public void freezeCountPlus(int count) {
        if (!this.isParmitThisItemFreeze()) {
            return;
        }
        if (this.isFrozen()) {
            return;
        }
        count *= EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.ALL, ENCHANT_SIMBOL.\u6e29) ? 7 : 10;
        this.setFreezeCount(this.item_freeze_count + (count *= EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.ALL, ENCHANT_SIMBOL.\u6c37) ? 2 : 1));
        if (this.isFrozen()) {
            Enchant.itemFreeze(this);
            if (EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.ALL, ENCHANT_SIMBOL.\u51b4)) {
                SE.LIGHT_ON.play();
                Scene_Action.getMe().tellRestStop();
                Player.me.setCondition(CONDITION.\u76ee\u85ac, 0);
            }
        }
    }

    public void freezeCountReset() {
        this.item_freeze_count = 0;
    }

    public ItemDetail getCategory() {
        return ItemDetail.getCategory(this);
    }

    public String getClassName() {
        return "";
    }

    public String getColoredName(boolean icon) {
        return this.getColoredName();
    }

    protected String[] getExplan() {
        return this.exn;
    }

    protected String getFlavor() {
        return null;
    }

    public int getForgeValue() {
        return this.forge_value;
    }

    public int getFreeseStep() {
        int index = this.isFrozen() ? 2 : (this.isCold() ? 1 : 0);
        return index;
    }

    public int getFreezeCount() {
        return this.item_freeze_count;
    }

    @Override
    public final Image getImage() {
        return this.IM.getImage(this.getFreeseStep());
    }

    public Image getImage(DIRECTION direction) {
        return this.getImage();
    }

    public final Image_Artifact getImage_Artifact() {
        return this.IM;
    }

    public ITEM_CASE getITEM_CASE() {
        return this.ITEM_CASE;
    }

    public String getLastPackage() {
        return null;
    }

    public List<ENCHANT_SIMBOL> getListComposition() {
        return this.list_composition;
    }

    public List<ENCHANT_SIMBOL> getListCompositionIncludeEnchant() {
        ArrayList<ENCHANT_SIMBOL> list = new ArrayList<ENCHANT_SIMBOL>();
        list.add(this.sim);
        for (ENCHANT_SIMBOL es : this.getListComposition()) {
            list.add(es);
        }
        return list;
    }

    public ArrayList<String> getListItemExplan(ArrayList<String> list) {
        list.add(this.getName());
        if (this.sim != null) {
            list.add("\u5370: ".concat(this.sim.getSimbolName()));
        }
        String use = new String();
        String[] stringArray = this.getExplan();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            use = use.concat(str);
            ++n2;
        }
        list.add(use);
        return list;
    }

    public ArrayList<String> getListTrapExplan(ArrayList<String> list) {
        list.add(this.getName());
        String use = new String();
        String[] stringArray = this.getExplan();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            use = use.concat(str);
            ++n2;
        }
        list.add(use);
        return list;
    }

    public int getMerchantBuyValue() {
        int multi = this instanceof SpellCard ? 8 : (this instanceof Staff ? 4 : 2);
        int pages = this.getMerchantSoldValue() * multi;
        if (pages < 1) {
            pages = 1;
        }
        if (pages > 800) {
            pages = 800;
        }
        return pages;
    }

    public int getMerchantSoldValue() {
        return 1;
    }

    public String getOneLineText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.sim != null ? this.sim.getSimbolName() : " -");
        sb.append(" ");
        if (this instanceof SpellCard) {
            sb.append("\u653b:");
            sb.append(this.itemEnchantPower(STATUS.STR));
            sb.append("\u5b88:");
            sb.append(this.itemEnchantPower(STATUS.DEF));
            sb.append("\u5370\u6570:");
            sb.append(this.composition_number);
        } else {
            String[] stringArray = this.getExplan();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                sb.append(str);
                ++n2;
            }
        }
        return sb.toString();
    }

    protected String getSecondExplain_ByCategory() {
        return null;
    }

    protected abstract String getSecondExplain_ByEach();

    public int getShadow() {
        return -1;
    }

    public final String getTrueName() {
        return this.name;
    }

    protected void init() {
        CSVLoadSupporter<String> list = CSVLoadSupporter.loadCSV(this.getClass().getSimpleName(), Base_Artifact.class, "\t");
        if (list != null) {
            this.name = (String)list.get(0);
            this.flag_pass_turn = list.isTrue(1);
            this.exn = ((String)list.get(2)).split("\\$");
            if (!this.flag_pass_turn) {
                String[] e = new String[this.exn.length + 1];
                int i = 0;
                while (i < this.exn.length) {
                    e[i + 1] = this.exn[i];
                    ++i;
                }
                e[0] = "[\u30bf\u30fc\u30f3\u7d4c\u904e\u306a\u3057]";
                this.exn = e;
            }
        } else if (this.name.matches("\u540d\u7121\u3057\u306eDISC")) {
            this.flag_pass_turn = true;
        } else {
            System.out.println("[@Base_artifact.init()]NosuchArtifact Exception :" + this.name);
        }
    }

    public void initScreenPoint() {
        if (WithinOutofScreen.isOutside(this)) {
            this.screen_point = ObjectPoint.getDangeonScreenPoint(this.mass_point);
            this.screen_point.translate(-50 * this.direction.X * 3, -50 * this.direction.Y * 3);
        }
    }

    public boolean isAbleToCurse() {
        return true;
    }

    public boolean isCold() {
        return this.item_freeze_count > 65;
    }

    public boolean isCurse() {
        return this.curse;
    }

    public boolean isCurse_And_isItViewed() {
        return this.isCurse();
    }

    public boolean isDemandWaiting() {
        return false;
    }

    public boolean isDevice() {
        return false;
    }

    public boolean isEnchantedAndCursed() {
        return this.isCurse() && Enchant.isEnchanted(this);
    }

    public boolean isEnchantedNow() {
        return Enchant.isEnchanted(this);
    }

    public boolean isFateToBeDeleted() {
        return this.flag_hatate;
    }

    public boolean isFlagPassTurn() {
        return this.flag_pass_turn;
    }

    public boolean isFrozen() {
        return this.item_freeze_count >= 91;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isHitToItem() {
        return false;
    }

    public boolean isHolyPoint(Base_Creature source, Integer damage) {
        return false;
    }

    public boolean isMerchant() {
        return this.flag_merchant;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public boolean isNeglectiveForWall() {
        return false;
    }

    public boolean isNonFrozen() {
        return this.flag_no_frozen;
    }

    public boolean isNoWasteWithThrowing() {
        return false;
    }

    public boolean isParmitThisItemFreeze() {
        return !this.isFrozen();
    }

    public boolean isPerfectCheked() {
        return this.isStaticCheked();
    }

    public final boolean isPlayerOn() {
        return this.getMassPoint().x == Player.me.getMassPoint().x && this.getMassPoint().y == Player.me.getMassPoint().y;
    }

    public boolean isPunishment() {
        return this.flag_punishment;
    }

    public boolean isStaticCheked() {
        if (this.checked_static) {
            return true;
        }
        this.checked_static = Checker.isStaticChecked(this);
        return this.checked_static;
    }

    public boolean isUsable() {
        if (this.isFrozen() && BonusConductor.\u6c17\u5206\u5c4b_\u6c37\u7981\u6b62()) {
            return false;
        }
        if (this.isCurse_And_isItViewed()) {
            return false;
        }
        if (this.isMerchant()) {
            return false;
        }
        if (this instanceof SpellCard) {
            SpellCard c = (SpellCard)this;
            return c.isAbleToUse();
        }
        return true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void itemBreak() {
        if (this.isEnchantedNow()) {
            Enchant.forceToRemove(this);
        }
        Belongings.remove(this);
    }

    public boolean itemCurseMessage() {
        if (this.isCurse()) {
            Message.set(this.getColoredName().concat("\u306f"), "\u546a\u308f\u308c\u3066\u3044\u308b\u70ba\u3001\u5916\u3059\u4e8b\u304c\u51fa\u6765\u306a\u3044");
            return true;
        }
        return false;
    }

    public abstract int itemEnchantPower(STATUS var1);

    public abstract void itemHit(Base_Creature var1, Base_Creature var2);

    protected void itemHit_NoEspeciality(Base_Creature c, Base_Creature c2) {
        R ran = new R();
        int damage = ((Random)ran).nextInt(2) + 1;
        Message.set(this.getColoredName(), "\u306f", c.getColoredName(), "\u306b\u5f53\u305f\u3063\u305f\uff01");
        if (c2 == null) {
            Damage.damage(this, null, null, null, c, damage);
        } else {
            Damage.damage(c2, null, null, c2, c, damage);
        }
    }

    public void itemHitCheck(boolean ento, Base_Creature c, Base_Artifact a) {
    }

    public boolean itemHitCheck(boolean ento, Base_Creature subject, Base_Creature object) {
        if (object.itemHit(this, ento, subject, object)) {
            if (this.isCurse() || this.getListComposition().contains((Object)ENCHANT_SIMBOL.\u91d1)) {
                this.itemHit_NoEspeciality(object, subject);
            } else {
                this.itemHit(object, subject);
            }
            return true;
        }
        return false;
    }

    public boolean itemPickUp() {
        if (Belongings.pickUpItem(this)) {
            if (this instanceof Scrool && ((Scrool)this).isOpen()) {
                ((Scrool)this).setCrose();
                Message.set(this.getColoredName(), "\u3092\u9589\u3058\u305f");
            }
            return false;
        }
        return false;
    }

    public boolean itemSetOn() {
        if (!ItemFall.isAbleToFall_AroundPlayer()) {
            Message.set("\u3053\u308c\u4ee5\u4e0a\u7f6e\u3051\u306a\u3044");
            return false;
        }
        ItemFall.itemFall(Player.me.getMassPoint().getLocation(), this);
        Enchant.forceToRemove(this);
        Belongings.remove(this);
        Message.set(this.getColoredName().concat("\u3092\u7f6e\u3044\u305f"));
        if (this instanceof Base_Item) {
            ((Base_Item)this).flag_pick_checked = true;
        }
        return true;
    }

    public void itemThrow(Base_Creature c) {
        SE.THROW.play();
        this.itemThrow(c, ThrowingItem.HowToThrow.NORMAL);
    }

    public void itemThrow(Base_Creature c, ThrowingItem.HowToThrow how) {
        this.itemThrow(c, how, false);
    }

    public void itemThrow(Base_Creature c, ThrowingItem.HowToThrow how, boolean booted) {
        this.itemThrow(c, how, booted, 10);
    }

    public void itemThrow(Base_Creature c, ThrowingItem.HowToThrow how, boolean booted, int throw_max) {
        this.itemThrow(c, how, booted, throw_max, false);
    }

    public void itemThrow(Base_Creature c, ThrowingItem.HowToThrow how, boolean booted, int throw_max, boolean flag_magic) {
        boolean ento = false;
        if (how == ThrowingItem.HowToThrow.NORMAL || how == ThrowingItem.HowToThrow.SLOW || how == ThrowingItem.HowToThrow.BREAK) {
            if (this instanceof Base_Device) {
                ento = false;
            } else {
                ento = c instanceof Player && EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u9060\u6295);
                ento = ento || this instanceof \u30df\u30cb\u516b\u5366\u7089;
                ento = ento || throw_max == -1;
            }
        }
        this.itemThrow(c, how, booted, throw_max, flag_magic, ento);
    }

    private void itemThrow(Base_Creature c, ThrowingItem.HowToThrow how, boolean booted, int throw_max, boolean flag_magic, boolean ento) {
        Enchant.forceToRemove(this);
        Belongings.remove(this);
        if (c instanceof Player && BonusConductor.\u3072\u306d\u304f\u308c\u8005_\u53d7\u3051()) {
            Point p = c.getMassPoint().getLocation();
            Mass m = MassCreater.getMass(p);
            DIRECTION d = c.direction;
            while (m.WALKABLE) {
                p.translate(d.X, d.Y);
                m = MassCreater.getMass(p);
            }
            this.setMassPoint(p);
            this.direction = c.direction.getReverse();
        } else if (!flag_magic) {
            this.direction = c.direction;
            if (booted) {
                this.setMassPoint(c.getMassPoint().x + c.direction.X, c.getMassPoint().y + c.direction.Y);
            } else {
                this.setMassPoint(c.getMassPoint().getLocation());
            }
        } else {
            this.setMassPoint(this.getMassPoint().getLocation());
        }
        this.screen_point.x += this.direction.X * 50;
        this.screen_point.y += this.direction.Y * 50;
        ThrowingItem.launch(this, ento, throw_max);
        TaskOnMapObject.setThrow(new ThrowingItem(this, c, ento, how));
    }

    public void itemThrow(Base_Creature c, ThrowingItem.HowToThrow how, int throw_max) {
        this.itemThrow(c, how, false, throw_max);
    }

    public abstract boolean itemUse();

    public abstract void itemUseThis();

    public void itemUseThis_fromMenu(KeyHolder KH, Base_View view) {
        this.itemUseThis();
        KH.setKeyAccepter(Scene_Action.getMe());
    }

    public void remove() {
        if (this.isEnchantedNow()) {
            Enchant.forceToRemove(this);
        }
        Belongings.getListItems().remove(this);
        MapList.removeArtifact(this);
    }

    public final ArrayList<String> secondPageExplain() {
        int length = 22;
        ArrayList<String> list = new ArrayList<String>();
        String detail = this.isStaticCheked() ? this.getSecondExplain_ByEach() : "\u672a\u8b58\u5225\u306e\u30a2\u30a4\u30c6\u30e0\u3060";
        String[] arr = new String[]{this.getSecondExplain_ByCategory(), detail};
        int index = 0;
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            ++index;
            if (str != null) {
                String caption = index == 1 ? "\u3010\u5206\u985e\u3011" : "\u3010\u8a73\u7d30\u3011";
                if (!str.contains("@")) {
                    list.add(caption);
                }
                String[] stringArray2 = str.split("@");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string = stringArray2[n4];
                    int times = string.length() / length;
                    int i = 0;
                    while (i < times) {
                        list.add(string.substring(length * i, length * (i + 1)));
                        ++i;
                    }
                    list.add(string.substring(length * times));
                    ++n4;
                }
                list.add("");
            }
            ++n2;
        }
        return list;
    }

    public void setCurse(boolean curse) {
        if (curse) {
            if (this.isAbleToCurse()) {
                this.curse = curse;
            }
        } else {
            this.curse = curse;
        }
        \u5370\u90aa.setInfomation();
    }

    public void setFateToBeDeleted() {
        this.flag_hatate = true;
    }

    public void setFlagNoFrozen(boolean flag) {
        this.flag_no_frozen = flag;
    }

    public void setForgeValue(int value) {
        this.forge_value += value;
        if (this.forge_value > 99) {
            this.forge_value = 99;
        } else if (this.forge_value < -99) {
            this.forge_value = -99;
        }
    }

    public void setFreezeCount(int count) {
        this.item_freeze_count = count;
        if (this.item_freeze_count < 0) {
            this.item_freeze_count = 0;
        } else if (this.item_freeze_count > 100) {
            this.item_freeze_count = 100;
        }
    }

    public Base_Artifact setItemNormalCondition() {
        this.setCurse(false);
        if (this instanceof SpellCard) {
            this.forge_value = 0;
        }
        return this;
    }

    @Override
    public void setMassPoint_ParabolaJump_NoAttack(Point p) {
        super.setMassPoint_ParabolaJump_NoAttack(p);
        this.upDate();
        this.upDate();
    }

    public void setMassPoint_ParabolaJump_NoAttack(Point p, Task task) {
        this.setMassPoint_ParabolaJumpAttack(p, task);
        this.mass_point = p;
        this.flag_jump_no_attack = true;
        this.upDate();
        this.upDate();
    }

    public void setMassPoint_ParabolaJump_NoAttack_PotBreak(Point p) {
        this.setMassPoint_ParabolaJump_NoAttack(p);
    }

    public void setMerchant(boolean b) {
        this.flag_merchant = b;
    }

    public void setMoveAnimating(boolean b) {
        this.flag_move_animating = b;
    }

    public void setPunishment(boolean b) {
        this.flag_punishment = b;
    }

    public void setSampleItem(boolean unknown) {
        this.flag_sample = true;
        this.flag_unknown = unknown;
        this.setCurse(false);
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean staticCheck() {
        if (!this.isStaticCheked()) {
            SE.CHECK.play();
            String str = this.getColoredName();
            Checker.checkStatic(this);
            Message.set(str, "\u306f", this.getName(), "\u3060\u3063\u305f");
            return true;
        }
        return false;
    }

    public String test() {
        return this.getSecondExplain_ByEach();
    }

    public abstract boolean walkOnAction();

    public boolean walkOnAction(boolean b) {
        return this.walkOnAction();
    }

    public boolean waterAction() {
        return true;
    }

    public static enum ENCHANT_CASE {
        ENCHANT;

    }

    protected static enum GROW_RATE {
        \u65e9\u719f,
        \u901a\u5e38,
        \u6669\u6210;

    }

    public static enum ITEM_CASE {
        DISC,
        SPELLCARD,
        WEAPOM,
        SHIELD,
        ETC,
        FOOD,
        SCROOL,
        GRASS,
        TRAP,
        RING,
        STAFF,
        ARROW;

    }

    public static enum STATUS {
        STR,
        DEF,
        SPECIAL;

    }
}

