/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.ThrowingItem;
import dangeon.controller.task.Task;
import dangeon.model.condition.CONDITION;
import dangeon.model.map.EnemyFall;
import dangeon.model.map.MapList;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Player;
import dangeon.util.Damage;
import dangeon.util.ObjectPoint;
import dangeon.view.detail.MiniMap;
import dangeon.view.util.WithinOutofScreen;
import java.awt.Image;
import java.awt.Point;
import java.io.Serializable;
import main.res.SE;
import main.util.DIRECTION;

public abstract class Base_MapObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int LV = 1;
    protected Point mass_point;
    protected Point screen_point;
    protected boolean flag_move_animating = false;
    public DIRECTION direction = DIRECTION.DOWN;
    protected Point jump_point;
    public int jumped_away_y = 0;
    public int jumped_away_x_speed = 0;
    public int jumped_away_y_speed = 0;
    public int jumped_away_y_speed_shadow = 0;
    protected int jumped_away_frame = -1;
    protected int jumped_away_frame_max = 0;
    protected boolean flag_jump_no_attack;
    protected Point delt = new Point(0, 0);
    protected String name;
    protected Task at_movement_end_task = null;
    private int move_speed_level = -1;

    protected Base_MapObject(String name, Point p, int level) {
        this.name = name;
        this.mass_point = p.getLocation();
        this.screen_point = ObjectPoint.getDangeonScreenPoint(this.mass_point);
        this.LV = level;
    }

    public void addDelt(DIRECTION direction) {
        this.addDelt(direction, 1);
    }

    public void addDelt(DIRECTION direction, int d) {
        switch (direction) {
            case DOWN: {
                this.delt.y += d;
                break;
            }
            case DOWN_LEFT: {
                this.delt.x -= d;
                this.delt.y += d;
                break;
            }
            case DOWN_RIGHT: {
                this.delt.x += d;
                this.delt.y += d;
                break;
            }
            case UP: {
                this.delt.y -= d;
                break;
            }
            case UP_LEFT: {
                this.delt.x -= d;
                this.delt.y -= d;
                break;
            }
            case UP_RIGHT: {
                this.delt.x += d;
                this.delt.y -= d;
                break;
            }
            case LEFT: {
                this.delt.x -= d;
                break;
            }
            case RIGHT: {
                this.delt.x += d;
            }
        }
    }

    public void endJump() {
        this.jump_point = null;
        this.jumped_away_y = 0;
        this.jumped_away_frame = -1;
    }

    protected void endParabonalJump() {
        Base_Creature c = MapList.getCreature(this.jump_point);
        ThrowingItem th = TaskOnMapObject.getThrow();
        if (c != null && c.conditionCheck(CONDITION.\u53cd\u5c04) && th != null && !th.isReflected()) {
            th.setReflected(true);
            this.direction = this.direction.getReverse();
            this.jumped_away_y = -1;
            this.setMassPoint_ParabolaJumpAttack(this.mass_point);
            this.upDate_Jump();
        } else if (this.at_movement_end_task != null) {
            Point p = this.mass_point;
            Point screen = this.screen_point.getLocation();
            this.setMassPoint(this.jump_point);
            this.at_movement_end_task.work();
            this.at_movement_end_task = null;
            this.setMassPoint(p);
            this.screen_point.x = screen.x;
            this.screen_point.y = screen.y;
        } else {
            this.setMassPoint(this.jump_point);
            if (!(this instanceof Base_Creature) || c == null || c == this) {
                this.endJump();
            } else {
                String s = "\u7a7a\u4e2d\u304b\u3089\u6575\u306b\u3076\u3064\u304b\u3063\u305f\u885d\u6483\u3067\u5012\u308c\u305f";
                Damage.damageNoMessage(this, s, c, (Base_Creature)this, 5);
                Damage.damageNoMessage(this, s, (Base_Creature)this, c, 5);
                this.jumped_away_y = -1;
                this.setMassPoint_ParabolaJumpAttack(EnemyFall.getPoint(this.jump_point));
                this.upDate_Jump();
            }
        }
    }

    public void flagMoveAnimeating() {
    }

    public String getColoredName() {
        return this.name;
    }

    public Point getDelt() {
        return this.delt;
    }

    public DIRECTION getDirection() {
        return this.direction;
    }

    public abstract Image getImage();

    public int getJumpDY() {
        return this.jumped_away_y;
    }

    public final int getLV() {
        return this.LV;
    }

    public Point getMassPoint() {
        return this.mass_point;
    }

    public int getMaxLV() {
        return this.isLvLimitBreak() ? 4 : 3;
    }

    public String getName() {
        return this.name;
    }

    public Point getScreenPoint() {
        return this.screen_point;
    }

    public boolean isAnimating() {
        if (this.isJumping()) {
            return true;
        }
        return this.flag_move_animating;
    }

    public boolean isAnimeComletelyEnded() {
        return ObjectPoint.isNoDifferenceBetweenMass_Screen(this);
    }

    public boolean isJumping() {
        return this.jump_point != null || this.jumped_away_y != 0;
    }

    protected boolean isLvLimitBreak() {
        return this.LV == 4;
    }

    public boolean isMoving() {
        return this.flag_move_animating;
    }

    public void setMassPoint(int x, int y) {
        this.setMassPoint(new Point(x, y));
    }

    public void setMassPoint(Point p) {
        this.mass_point = p.getLocation();
        this.screen_point = ObjectPoint.getDangeonScreenPoint(this.mass_point);
    }

    public void setMassPoint_Jump(Point p) {
        this.setMassPoint_Jump(p, null);
    }

    public void setMassPoint_Jump(Point p, Task task) {
        SE.WARP.play();
        this.jump_point = p.getLocation();
        this.jumped_away_frame = -1;
        this.jumped_away_y = 0;
        this.at_movement_end_task = task;
    }

    public void setMassPoint_ParabolaJump_NoAttack(Point p) {
        this.setMassPoint_ParabolaJumpAttack(p);
        this.mass_point = p;
        this.flag_jump_no_attack = true;
    }

    public void setMassPoint_ParabolaJumpAttack(Point p) {
        this.setMassPoint_ParabolaJumpAttack(p, null);
    }

    public void setMassPoint_ParabolaJumpAttack(Point p, Task task) {
        this.jump_point = p.getLocation();
        this.jumped_away_frame = 0;
        Point scp = ObjectPoint.getDangeonScreenPoint(this.jump_point);
        this.jumped_away_frame_max = this == Player.me ? 12 : 8;
        this.jumped_away_x_speed = (scp.x - this.screen_point.x) / (this.jumped_away_frame_max + 1);
        this.jumped_away_y_speed = (scp.y - this.screen_point.y) / (this.jumped_away_frame_max + 1);
        this.jumped_away_y_speed_shadow = -this.jumped_away_y / (this.jumped_away_frame_max + 1);
        this.at_movement_end_task = task;
    }

    public void setMassPoint_WalkLike(Point p, int move_speed_level) {
        this.setMassPoint_WalkLike(p, move_speed_level, null);
    }

    public void setMassPoint_WalkLike(Point p, int move_speed_level, Task task) {
        this.flag_move_animating = true;
        this.mass_point = p.getLocation();
        MiniMap.openTiles();
        this.move_speed_level = move_speed_level;
        this.at_movement_end_task = task;
    }

    public void upDate() {
        if (this.jump_point != null) {
            this.upDate_Jump();
        } else {
            int speed = Player.me.isDushing() ? 50 : 10;
            if (this.move_speed_level != -1) {
                speed *= this.move_speed_level;
            }
            this.upDate(speed);
            if (this.move_speed_level != -1 && !this.flag_move_animating) {
                this.move_speed_level = -1;
            }
        }
    }

    public void upDate(int MOVE_SPEED) {
        int signal;
        Point dif = ObjectPoint.getDifferenceBetweenMass_Screen(this);
        if (dif.x == 0 && dif.y == 0) {
            if (this.at_movement_end_task != null) {
                Task end = this.at_movement_end_task;
                end.work();
                if (end != this.at_movement_end_task) {
                    return;
                }
                this.at_movement_end_task = null;
            }
            this.flag_move_animating = false;
            return;
        }
        if (!(this instanceof Base_Artifact) && WithinOutofScreen.isOutside(this)) {
            this.screen_point = ObjectPoint.getDangeonScreenPoint(this.mass_point);
            return;
        }
        if (dif.x != 0) {
            signal = dif.x > 0 ? 1 : -1;
            this.screen_point.x += MOVE_SPEED * signal;
            if (ObjectPoint.getDifferenceBetweenMass_Screen((Base_MapObject)this).x * signal < 0) {
                this.screen_point.x = ObjectPoint.getDangeonScreenPoint((Point)this.mass_point).x;
            }
        }
        if (dif.y != 0) {
            signal = dif.y > 0 ? 1 : -1;
            this.screen_point.y += MOVE_SPEED * signal;
            if (ObjectPoint.getDifferenceBetweenMass_Screen((Base_MapObject)this).y * signal < 0) {
                this.screen_point.y = ObjectPoint.getDangeonScreenPoint((Point)this.mass_point).y;
            }
        }
        dif = ObjectPoint.getDifferenceBetweenMass_Screen(this);
        this.flag_move_animating = this.at_movement_end_task != null ? true : Math.abs(dif.x) > MOVE_SPEED || Math.abs(dif.y) > MOVE_SPEED;
    }

    protected void upDate_Jump() {
        if (this.jumped_away_frame == -1) {
            this.jumped_away_y -= 30;
            if (this.jumped_away_y < -340) {
                this.setMassPoint(this.jump_point);
                if (this.at_movement_end_task != null) {
                    this.at_movement_end_task.work();
                    this.at_movement_end_task = null;
                } else {
                    this.endJump();
                }
            }
        } else {
            this.screen_point.x += this.jumped_away_x_speed;
            this.screen_point.y += this.jumped_away_y_speed;
            this.jumped_away_y += this.jumped_away_y_speed_shadow;
            int signal = this.jumped_away_frame > this.jumped_away_frame_max / 2 ? 1 : -1;
            this.jumped_away_y += signal * 10 / 2;
            if (++this.jumped_away_frame >= this.jumped_away_frame_max) {
                this.jumped_away_frame = this.jumped_away_frame_max;
                if (this.flag_jump_no_attack) {
                    if (this.at_movement_end_task != null) {
                        this.at_movement_end_task.work();
                        this.at_movement_end_task = null;
                    } else {
                        this.endJump();
                    }
                } else {
                    this.endParabonalJump();
                }
            }
        }
    }
}

