/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.map.field.random;

import dangeon.controller.TaskOnMapObject;
import dangeon.latest.scene.action.menu.Book;
import dangeon.latest.scene.action.message.ConvEvent;
import dangeon.model.config.StoryManager;
import dangeon.model.config.table.ItemTable;
import dangeon.model.map.ItemFall;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.map.NextFloor;
import dangeon.model.map.PresentField;
import dangeon.model.map.field.Base_Map;
import dangeon.model.map.field.random.Base_Map_Random;
import dangeon.model.map.field.random.bossmap.BossMap_Daisakusen;
import dangeon.model.map.field.random.bossmap.BossMap_Hisoutensoku;
import dangeon.model.map.field.random.bossmap.BossMap_Sakasa;
import dangeon.model.map.field.random.bossmap.BossMap_Tokiko;
import dangeon.model.map.field.special.map.BossMap;
import dangeon.model.map.field.special.map.EndingMap;
import dangeon.model.map.field.town.map.KoumaKan;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.Stairs;
import dangeon.model.object.artifact.item.arrow.\u9244\u306e\u77e2;
import dangeon.model.object.artifact.item.check.Checker;
import dangeon.model.object.artifact.item.scrool.\u3042\u3068\u304c\u304d;
import dangeon.model.object.artifact.item.scrool.\u5e7b\u60f3\u90f7\u7e01\u8d77;
import dangeon.model.object.artifact.item.scrool.\u6167\u97f3\u306e\u6b74\u53f2\u66f8;
import dangeon.model.object.creature.npc.second.Takarabako;
import dangeon.util.R;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import main.res.BGM;
import main.res.Image_MapTip;
import main.res.SE;
import main.util.DIRECTION;

public class \u904b\u547d\u306e\u30ef\u30eb\u30c4
extends Base_Map_Random {
    private static final long serialVersionUID = 1L;

    public \u904b\u547d\u306e\u30ef\u30eb\u30c4() {
        super(Base_Map_Random.Difficulty.Hard, 2, 0);
    }

    @Override
    protected void addSpecialFloor(HashMap<Integer, Base_Map> hash) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        FloorConducter[] floorConducterArray = FloorConducter.values();
        int n = floorConducterArray.length;
        int n2 = 0;
        while (n2 < n) {
            FloorConducter fc = floorConducterArray[n2];
            list.add(fc.floor);
            ++n2;
        }
        int i = 0;
        while (i < this.getBossLength()) {
            list.add(this.getXndBossFloor(i + 1));
            ++i;
        }
        Collections.sort(list);
        int count = 0;
        for (Integer integer : list) {
            hash.put(integer, new MiddMap(++count));
        }
    }

    @Override
    public int defaultItemNumber() {
        int f = MapList.getFloor();
        if (f < FloorConducter.\u30b4\u30fc\u30b9\u30c8\u30ca\u30a4\u30c8\u30e0\u30fc\u30f3.floor) {
            return new R().nextInt(3) + 2;
        }
        if (f < FloorConducter.\u4e00\u6761\u623b\u308a\u6a4b.floor) {
            return new R().nextInt(3) + new R().nextInt(2) + 2;
        }
        return new R().nextInt(4) + 2;
    }

    @Override
    public BGM getBGM() {
        return FloorConducter.get().bgm;
    }

    private int getBossLength() {
        return 4;
    }

    @Override
    public BossMap getBossMap() {
        int floor = MapList.getFloor();
        if (floor <= this.getXndBossFloor(1)) {
            return new BossMap_Daisakusen(this){
                private static final long serialVersionUID = 1L;

                @Override
                protected Base_Artifact getStair() {
                    return \u904b\u547d\u306e\u30ef\u30eb\u30c4.this.getNextStair();
                }
            };
        }
        if (floor <= this.getXndBossFloor(2)) {
            return new BossMap_Sakasa(this){
                private static final long serialVersionUID = 1L;

                @Override
                public void appearStair() {
                    \u6167\u97f3\u306e\u6b74\u53f2\u66f8 a = new \u6167\u97f3\u306e\u6b74\u53f2\u66f8(this.boss.getMassPoint());
                    Checker.checkStatic(a);
                    ItemFall.itemFall(a);
                    super.appearStair();
                }

                @Override
                protected Base_Artifact getStair() {
                    return \u904b\u547d\u306e\u30ef\u30eb\u30c4.this.getNextStair();
                }
            };
        }
        if (floor <= this.getXndBossFloor(3)) {
            return new BossMap_Hisoutensoku(this){
                private static final long serialVersionUID = 1L;

                @Override
                public void appearStair() {
                    \u5e7b\u60f3\u90f7\u7e01\u8d77 a = new \u5e7b\u60f3\u90f7\u7e01\u8d77(this.boss.getMassPoint());
                    Checker.checkStatic(a);
                    ItemFall.itemFall(a);
                    super.appearStair();
                }

                @Override
                protected Base_Artifact getStair() {
                    return \u904b\u547d\u306e\u30ef\u30eb\u30c4.this.getNextStair();
                }
            };
        }
        if (floor <= this.getXndBossFloor(4)) {
            return new BossMap_Tokiko(this){
                private static final long serialVersionUID = 1L;

                @Override
                public void appearStair() {
                    \u3042\u3068\u304c\u304d a = new \u3042\u3068\u304c\u304d(this.boss.getMassPoint());
                    Checker.checkStatic(a);
                    ItemFall.itemFall(a);
                    super.appearStair();
                }
            };
        }
        return super.getBossMap();
    }

    @Override
    public String getClassName() {
        return "\u904b\u547d\u306e\u30ef\u30eb\u30c4";
    }

    @Override
    protected void getExn_Warning(ArrayList<String> list) {
        list.add("\u6700\u96e3\u95a2\u306e\u30c0\u30f3\u30b8\u30e7\u30f3\u3060\u3088");
        list.add("\u30a2\u30a4\u30c6\u30e0\u3092\u6301\u3061\u8fbc\u3081\u306a\u3044\u3057");
        list.add("\u843d\u3061\u3066\u3044\u308b\u30a2\u30a4\u30c6\u30e0\u3082\u672a\u8b58\u5225\u3060\u3088");
        list.add("\u30ec\u30d9\u30eb\u306e\u9ad8\u3044\u6575\u304c\u51fa\u73fe\u3059\u308b\u3088");
        list.add("\u30dc\u30b9\u3082\u3044\u308b\u304b\u3089\u6c17\u3092\u3064\u3051\u3066\u306d");
    }

    @Override
    public int[] getGouseiFloor() {
        return new int[]{14, 44, 74};
    }

    @Override
    public Image_MapTip getMapTip() {
        return FloorConducter.get().getMaptip();
    }

    @Override
    public int getMaxFloor() {
        return 99;
    }

    @Override
    public int getMonsterHouse() {
        return 7;
    }

    private Stairs getNextStair() {
        return this.getNextStair(MassCreater.getStairsIP());
    }

    private Stairs getNextStair(Point p) {
        return new Stairs(p, this){
            private static final long serialVersionUID = 1L;

            @Override
            public void move() {
                PresentField.setPresentField(this.bm);
                NextFloor.next(this.bm);
            }
        };
    }

    @Override
    public int getSaisenParcent() {
        if (MapList.getFloor() <= FloorConducter.\u904b\u547d\u306e\u30ef\u30eb\u30c4.floor) {
            return 6;
        }
        if (MapList.getFloor() > FloorConducter.\u661f\u306b\u9858\u3044\u3092.floor) {
            return 2;
        }
        return 8;
    }

    @Override
    public int getShopParcent() {
        if (MapList.getFloor() <= FloorConducter.\u904b\u547d\u306e\u30ef\u30eb\u30c4.floor) {
            return 5;
        }
        if (MapList.getFloor() > FloorConducter.\u661f\u306b\u9858\u3044\u3092.floor) {
            return 0;
        }
        return 2;
    }

    @Override
    public int getSMH_EnemyLV() {
        if (MapList.getFloor() <= FloorConducter.\u30ec\u30b8\u30b9\u30bf\u30f3\u30b9\u30d9\u30fc\u30b9.floor) {
            return super.getSMH_EnemyLV();
        }
        return 4;
    }

    @Override
    public int getSMH_Percent() {
        if (MapList.getFloor() <= FloorConducter.\u30cd\u30af\u30b9\u30c8\u30d2\u30b9\u30c8\u30ea\u30fc.floor) {
            return 16;
        }
        if (MapList.getFloor() <= FloorConducter.\u8ab0\u3082\u3044\u306a\u304f\u306a\u308b\u306e\u304b.floor) {
            return 12;
        }
        return 0;
    }

    @Override
    public StoryManager getStoryManager_ClearFlag() {
        return StoryManager.\u904b\u547d\u306e\u30ef\u30eb\u30c4clear;
    }

    @Override
    public StoryManager getStoryManager_FirstFlag() {
        return StoryManager.\u904b\u547d\u306e\u30ef\u30eb\u30c4ok;
    }

    @Override
    public String getTitle() {
        return FloorConducter.get().toString();
    }

    @Override
    public int getTrapDefaultValue() {
        return super.getTrapDefaultValue();
    }

    private int getXndBossFloor(int index) {
        if (index == 1) {
            return 13;
        }
        if (index == 2) {
            return 59;
        }
        if (index == 3) {
            return 73;
        }
        if (index == 4) {
            return 98;
        }
        return -1;
    }

    @Override
    protected boolean isBGMDemandedToPlay() {
        int f = MapList.getFloor();
        int[] floors = new int[FloorConducter.values().length];
        int i = 0;
        while (i < floors.length) {
            if (f == FloorConducter.values()[i].floor + 1) {
                return true;
            }
            ++i;
        }
        return super.isBGMDemandedToPlay();
    }

    private boolean isBoss(int floor) {
        int i = 0;
        while (i < this.getBossLength()) {
            if (this.getXndBossFloor(i + 1) == floor) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected boolean isFixFloor() {
        if (MapList.getFloor() > FloorConducter.\u661f\u306b\u9858\u3044\u3092.floor) {
            return new R().nextInt(100) < 20;
        }
        return new R().nextInt(100) < 10;
    }

    @Override
    public boolean isLightful() {
        return false;
    }

    @Override
    public boolean isLvUpedEnemy() {
        return true;
    }

    @Override
    public boolean isWarningEnemy() {
        return true;
    }

    private static enum FloorConducter {
        ERROR(0, null, Image_MapTip.\u7d05\u9b54\u9928, "\u904b\u547d\u306e\u30ef\u30eb\u30c4"),
        \u904b\u547d\u306e\u30ef\u30eb\u30c4(7, BGM.frozen_night, Image_MapTip.\u7d05\u9b54\u9928),
        \u30b4\u30fc\u30b9\u30c8\u30ca\u30a4\u30c8\u30e0\u30fc\u30f3(14, BGM.hyougenyakou, Image_MapTip.stars),
        \u30aa\u30fc\u30eb\u30c9\u30d2\u30b9\u30c8\u30ea\u30fc(24, BGM.kanpyo_ch_sprite, Image_MapTip.\u8349\u539f, "\u904e\u304e\u53bb\u308a\u3057\u590f"),
        \u4e00\u6761\u623b\u308a\u6a4b(29, BGM.kanpyo_ch2_fairy, Image_MapTip.\u547d\u84ee\u5bfa),
        \u30cd\u30af\u30b9\u30c8\u30d2\u30b9\u30c8\u30ea\u30fc(44, BGM.kanpyo_ch2_hexa, Image_MapTip.\u8349\u539f_\u79cb, "\u601d\u3044\u51fa\u306b\u306a\u308b\u79cb"),
        \u30ec\u30b8\u30b9\u30bf\u30f3\u30b9\u30d9\u30fc\u30b9(60, BGM.to_kou_chiruno, Image_MapTip.\u30b9\u30ad\u30de, "\u5996\u7cbe\u5927\u9769\u547d"),
        \u661f\u306b\u9858\u3044\u3092(74, BGM.kanpyo_ch2_fff, Image_MapTip.stars, "\u5947\u8de1\u306b\u304a\u7948\u308a"),
        \u8ab0\u3082\u3044\u306a\u304f\u306a\u308b\u306e\u304b(86, BGM.kanpyo_ch_bbcc, Image_MapTip.\u5730\u970a\u6bbf_\u6c34),
        \u904b\u547d\u306e\u30e9\u30d7\u30bd\u30c7\u30a3(100, BGM.kanpyo_ch2_bbcc, Image_MapTip.\u5730\u970a\u6bbf);

        private final int floor;
        private final BGM bgm;
        private final Image_MapTip map_tip;
        private final String title;

        private static FloorConducter get() {
            if (PresentField.get() instanceof KoumaKan) {
                return ERROR;
            }
            int floor = MapList.getFloor();
            FloorConducter[] floorConducterArray = FloorConducter.values();
            int n = floorConducterArray.length;
            int n2 = 0;
            while (n2 < n) {
                FloorConducter fc = floorConducterArray[n2];
                if (floor <= fc.floor) {
                    return fc;
                }
                ++n2;
            }
            return ERROR;
        }

        private FloorConducter(int to_floor, BGM bgm, Image_MapTip map_tip) {
            this(to_floor, bgm, map_tip, null);
        }

        private FloorConducter(int to_floor, BGM bgm, Image_MapTip map_tip, String title) {
            this.floor = to_floor;
            this.bgm = bgm;
            this.map_tip = map_tip;
            this.title = title;
        }

        public Image_MapTip getMaptip() {
            return this.map_tip;
        }

        public String toString() {
            if (this.title != null) {
                return this.title;
            }
            return super.toString();
        }
    }

    private class MiddMap
    extends EndingMap {
        private static final long serialVersionUID = 1L;
        private int count;

        public MiddMap(int count) {
            super(\u904b\u547d\u306e\u30ef\u30eb\u30c4.this);
            this.count = count - 1;
        }

        @Override
        public String getMapName() {
            return "\u5883\u754c\u306e\u8e0a\u308a\u5834";
        }

        @Override
        protected Base_MapObject getStair(boolean flag_no_item) {
            Point center = new Point(19, 12);
            int i = 0;
            DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
            int n = dIRECTIONArray.length;
            int n2 = 0;
            while (n2 < n) {
                DIRECTION d = dIRECTIONArray[n2];
                if (i++ == this.count) break;
                if (i == 1) {
                    this.add(new \u9244\u306e\u77e2(center.getLocation(), false).setArrowRest(15));
                } else {
                    this.add(ItemTable.itemReturn(d.getFrontPoint(center.getLocation()), null));
                }
                ++n2;
            }
            this.add(new Takarabako(center));
            return new Stairs(this.getExitPoint(), \u904b\u547d\u306e\u30ef\u30eb\u30c4.this){
                private static final long serialVersionUID = 1L;

                private void boss() {
                    new ConvEvent(new String[]{"\u305f\u3060\u306a\u3089\u306c\u6c17\u914d\u304c\u3059\u308b\u2026"}){

                        @Override
                        protected Book getContent1() {
                            return new Book("BOSS\u6226\u3078\u9032\u3080"){

                                @Override
                                protected void work() {
                                    this.move();
                                }
                            };
                        }

                        @Override
                        protected Book getContent2() {
                            return new Book("\u307e\u3060"){

                                @Override
                                protected void work() {
                                }
                            };
                        }
                    };
                }

                protected void getNextStairFromMidMap() {
                    if (\u904b\u547d\u306e\u30ef\u30eb\u30c4.this.isBoss(MapList.getFloor())) {
                        this.boss();
                    } else {
                        TaskOnMapObject.setTaskStairs(this);
                    }
                }

                @Override
                public String[] getSlection() {
                    if (\u904b\u547d\u306e\u30ef\u30eb\u30c4.this.isBoss(MapList.getFloor())) {
                        return new String[]{"BOSS\u6226\u3078\u9032\u3080", "\u307e\u3060"};
                    }
                    return super.getSlection();
                }

                @Override
                public void move() {
                    if (\u904b\u547d\u306e\u30ef\u30eb\u30c4.this.isBoss(MapList.getFloor())) {
                        SE.SYSTEM_STAIR_STEP.play();
                        MiddMap.this.BMR.goToBossMap();
                    } else {
                        super.move();
                    }
                }

                @Override
                public boolean walkOnAction() {
                    this.getNextStairFromMidMap();
                    return false;
                }
            };
        }
    }
}

