/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.map.field.random;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.task.Task;
import dangeon.model.config.Config;
import dangeon.model.config.StoryManager;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.map.StairScene;
import dangeon.model.map.field.Base_Map;
import dangeon.model.map.field.special.map.BossMap;
import dangeon.model.map.field.special.map.EndingMap;
import dangeon.model.map.field.special.map.GouseiMap;
import dangeon.model.map.field.town.map.FairyPlace;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.food.\u5927\u304d\u306a\u304a\u306b\u304e\u308a;
import dangeon.model.object.artifact.item.pot.\u304b\u304d\u6c37\u5668;
import dangeon.model.object.artifact.item.ring.Ring;
import dangeon.model.object.artifact.item.spellcard.\u5927\u5996\u7cbe\u306e\u30ab\u30fc\u30c9;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.save.SaveLoad;
import dangeon.util.R;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import main.res.BGM;
import main.util.BlackOut;
import main.util.DIRECTION;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public abstract class Base_Map_Random
extends Base_Map {
    private static final long serialVersionUID = 1L;
    protected List<Integer> gold_saisen = new ArrayList<Integer>();
    protected List<Integer> gold_saisen_fix = new ArrayList<Integer>();
    private final Difficulty DIFFICULTY;
    public final int UN_CHECKED_LEVEL;
    public final Integer ITEM_MAX;

    protected Base_Map_Random() {
        this(Difficulty.Normal, 2, null);
    }

    protected Base_Map_Random(Difficulty difficulty, int un_checked_level, Integer item_max) {
        super("random", 650);
        this.DIFFICULTY = difficulty;
        this.UN_CHECKED_LEVEL = un_checked_level;
        this.ITEM_MAX = item_max;
    }

    @Override
    protected void add(Base_MapObject ... os) {
        super.add(os);
    }

    protected void addSpecialFloor(HashMap<Integer, Base_Map> hash) {
    }

    public void createFirstMap() {
        this.createFirstMap(false);
    }

    public void createFirstMap(boolean flag_retry_no_change) {
        if (flag_retry_no_change) {
            R.setFix(Config.getRetrySeed());
            SaveLoad.staticTempLoad();
        } else {
            long seed = this.getFixedRandom();
            R.setFix(seed);
            Config.saveRetrySeed(seed);
            new SaveLoad().saveItemsFirst();
        }
        Player.me.resetStatus();
        Player.me.setRestrictionFlags(this);
        StairScene.addTask(new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                Enchant.allRemove();
                Base_Artifact[] base_ArtifactArray = Base_Map_Random.this.initItems(Player.me.getMassPoint());
                int n = base_ArtifactArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Base_Artifact a = base_ArtifactArray[n2];
                    if (a != null) {
                        if (!Belongings.isMax()) {
                            Belongings.setItems(a);
                            if (Config.isEnchantedOnigiriFirst()) {
                                if (a instanceof \u5927\u304d\u306a\u304a\u306b\u304e\u308a) {
                                    Enchant.ANY2.setEnchant(a);
                                } else if (a instanceof Ring) {
                                    Enchant.ANY1.setEnchant(a);
                                }
                            }
                        }
                        a.check();
                    }
                    ++n2;
                }
                Player.me.setDirection(DIRECTION.DOWN);
            }
        });
        new MassCreater(this, null, true).createFirstMap(this.UN_CHECKED_LEVEL);
    }

    protected Base_Map createGouseiMap() {
        return new GouseiMap(this);
    }

    public int dangerLv(int floor) {
        int[] array = this.getGouseiFloor();
        if (array.length == 0) {
            return 0;
        }
        int i = 0;
        while (i < array.length) {
            if (floor < array[i]) {
                return i + Config.getFate() - 1;
            }
            ++i;
        }
        return array.length + Config.getFate() - 1;
    }

    public int expRate_From1To100() {
        return 100;
    }

    @Deprecated
    public ArrayList<Base_Artifact> firstItems() {
        return null;
    }

    @Override
    public BGM getBGM() {
        if (MapList.getFloor() < 80) {
            return BGM.kanpyo_ch_sprite;
        }
        return BGM.kanpyo_ch_bbcc;
    }

    public BossMap getBossMap() {
        return null;
    }

    @Override
    public String getCSVName() {
        StringBuilder sb = new StringBuilder();
        sb.append("csv/");
        sb.append(this.getClassName());
        sb.append("_");
        sb.append(this.getDIFFICULTY().name());
        sb.append(".csv");
        return sb.toString();
    }

    public Difficulty getDIFFICULTY() {
        return this.getDIFFICULTY(Config.getFate());
    }

    public Difficulty getDIFFICULTY(int fate) {
        return this.DIFFICULTY.get(fate);
    }

    @Override
    public Point getEntrancePoint() {
        return null;
    }

    public String[] getExn() {
        String w = Color.WHITE.toString();
        String g = StringFilter.NUMBERS.toString();
        ArrayList<String> list = new ArrayList<String>(10);
        list.add(String.valueOf(w) + "\u25c6" + this.getMapName() + "\u25c6");
        String a = "\u5168" + \u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(this.getMaxFloor()) + "\u968e";
        String b = String.valueOf(w) + "\u96e3\u6613\u5ea6\uff1a" + g + (Object)((Object)this.getDIFFICULTY());
        String s = "";
        if (this.getGouseiFloor().length == 0) {
            s = "\u306a\u3057";
        } else {
            int[] nArray = this.getGouseiFloor();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                s = String.valueOf(s) + String.valueOf(i) + ".5\u3000";
                ++n2;
            }
            s = String.valueOf(s.substring(0, s.length() - 1)) + "\u968e";
        }
        String c = String.valueOf(w) + "\u30b9\u30ad\u30de\u30d5\u30ed\u30a2\uff1a" + g + s;
        s = this.ITEM_MAX == null ? String.valueOf(g) + "\u53ef\u80fd" : (this.ITEM_MAX == 0 ? Color.ORANGE + "\u4e0d\u53ef" : String.valueOf(g) + this.ITEM_MAX + "\u30b3\u307e\u3067");
        String d = String.valueOf(w) + "\u6301\u3061\u8fbc\u307f\uff1a" + s;
        s = this.isBossMap() ? "\u3044\u308b" : "\u3044\u306a\u3044";
        String e = String.valueOf(w) + "BOSS\uff1a" + g + s;
        list.add(String.valueOf(a) + "&c" + e);
        list.add(String.valueOf(b) + "&c" + d);
        list.add(c);
        list.add("&--");
        this.getExn_Warning(list);
        list.add("");
        return list.toArray(new String[0]);
    }

    protected void getExn_Warning(ArrayList<String> list) {
    }

    @Override
    public String getFileName() {
        StringBuilder sb = new StringBuilder();
        if (Player.me.isFlag_next_monster_house()) {
            this.SPECIAL_NUMBER = 0;
            sb.append("res/map/special_floor/");
            sb.append(this.SPECIAL_NUMBER);
            sb.append(".map");
            return sb.toString();
        }
        if (this.isFixFloor()) {
            this.SPECIAL_NUMBER = new R().nextInt(5);
            sb.append("res/map/special_floor/");
            sb.append(this.SPECIAL_NUMBER);
            sb.append(".map");
            return sb.toString();
        }
        this.SPECIAL_NUMBER = -1;
        sb.append(this.FILE_NAME);
        sb.append(new R().nextInt(this.RANDOM_LENGTH));
        sb.append(".map");
        return sb.toString();
    }

    protected final Base_Map getFinalFloor() {
        return new EndingMap(this);
    }

    protected long getFixedRandom() {
        return System.nanoTime() / 1000000L;
    }

    public int[] getGoldFloor() {
        return this.getGouseiFloor();
    }

    public int getGoldSaisenParcent() {
        return 0;
    }

    public int[] getGouseiFloor() {
        return new int[0];
    }

    @Override
    public int getHealRate() {
        if (this.DIFFICULTY.isMoreThan(Difficulty.Normal)) {
            int rate = 6 - this.dangerLv(MapList.getFloor());
            if (rate > 0) {
                return super.getHealRate() * rate / 6;
            }
            return 60;
        }
        return super.getHealRate();
    }

    @Override
    public int getMonsterHouse() {
        return 5;
    }

    @Override
    public int getShopParcent() {
        return 5;
    }

    @Override
    public final HashMap<Integer, Base_Map> getSpecialFloor() {
        HashMap<Integer, Base_Map> hash = new HashMap<Integer, Base_Map>();
        this.addSpecialFloor(hash);
        int[] nArray = this.getGouseiFloor();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            hash.put(i, this.createGouseiMap());
            ++n2;
        }
        hash.put(this.getMaxFloor(), this.getFinalFloor());
        return hash;
    }

    public StoryManager getStoryManager_ClearFlag() {
        return null;
    }

    public StoryManager getStoryManager_FirstFlag() {
        return null;
    }

    @Override
    public int getTrapDefaultValue() {
        return this.getTrapDefaultValue(MapList.getFloor());
    }

    protected final int getTrapDefaultValue(int f) {
        int min;
        int range;
        if (f < 6) {
            range = 1;
            min = 2;
        } else if (f < 13) {
            range = 3;
            min = 2;
        } else if (f < 20) {
            range = 3;
            min = 3;
        } else {
            range = 4;
            min = 3;
        }
        return new R().nextInt(range) + min;
    }

    public void goToBossMap() {
        final BossMap map = this.getBossMap();
        new BlackOut("", new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                TaskOnMapObject.setNewMap(new MassCreater(map, false));
            }
        });
    }

    protected Base_Artifact[] initItems(Point p) {
        \u5927\u5996\u7cbe\u306e\u30ab\u30fc\u30c9 c;
        if (this.isDaichanCard()) {
            c = new \u5927\u5996\u7cbe\u306e\u30ab\u30fc\u30c9(p);
            c.createSpellCard(false, 0);
        } else {
            c = null;
        }
        int size = 4 - Config.getFate();
        if (size <= 0) {
            size = 1;
        }
        return new Base_Artifact[]{c, new \u5927\u304d\u306a\u304a\u306b\u304e\u308a(p), new \u304b\u304d\u6c37\u5668(p, size)};
    }

    @Override
    protected boolean isBGMDemandedToPlay() {
        return BGM.isBGMStatusStopped() || BGM.isSpecialBGMplaying() || MapList.getFloor() == 1;
    }

    public boolean isBossMap() {
        return this.getBossMap() != null;
    }

    protected boolean isDaichanCard() {
        return true;
    }

    @Override
    public boolean isDangerous() {
        return this.dangerLv(MapList.getFloor()) > 0;
    }

    @Override
    public final boolean isDungeon() {
        return true;
    }

    public boolean isFixedRandom() {
        return this.getFixedRandom() != -1L;
    }

    protected boolean isFixFloor() {
        return new R().nextInt(100) < 8;
    }

    public boolean isFixGoldSaisen() {
        int level = MapList.getFloor();
        return level >= this.gold_saisen_fix.get(0) && level <= this.gold_saisen_fix.get(1);
    }

    public boolean isGoldSaisenFloor() {
        int level = MapList.getFloor();
        int i = 0;
        while (true) {
            if (level >= this.gold_saisen.get(i) && level <= this.gold_saisen.get(i + 1)) {
                return true;
            }
            if (this.gold_saisen.size() < i + 3) break;
            i += 2;
        }
        return false;
    }

    @Override
    public boolean isHaraheru() {
        return true;
    }

    @Override
    public boolean isInsane() {
        return this.dangerLv(MapList.getFloor()) > 2;
    }

    @Override
    public boolean isLightful() {
        return false;
    }

    public Base_Map returnTown() {
        return new FairyPlace();
    }

    public static enum Difficulty {
        Phantasm(Color.GRAY, 4),
        Lunatic(Color.RED, 3),
        Hard(Color.ORANGE, 2),
        Normal(Color.PINK, 1),
        Easy(Color.CYAN, 0);

        public final String COLOR;
        public final int index;

        public static Difficulty getFromIndex(int index) {
            Difficulty[] difficultyArray = Difficulty.values();
            int n = difficultyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Difficulty d = difficultyArray[n2];
                if (d.index == index) {
                    return d;
                }
                ++n2;
            }
            return null;
        }

        private Difficulty(Color c, int index) {
            this.COLOR = c.toString();
            this.index = index;
        }

        public Difficulty get(int delt) {
            int max;
            int i = this.index + delt;
            int n = max = StoryManager.\u3042\u3068\u304c\u304d.hasFinished() ? Difficulty.Phantasm.index : Difficulty.Lunatic.index;
            if (i < 0) {
                i = 0;
            } else if (i > max) {
                i = max;
            }
            Difficulty[] difficultyArray = Difficulty.values();
            int n2 = difficultyArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Difficulty d = difficultyArray[n3];
                if (d.index == i) {
                    return d;
                }
                ++n3;
            }
            return null;
        }

        public boolean is(Base_Map_Random bmr) {
            return bmr.getDIFFICULTY().equals((Object)this);
        }

        public boolean isMoreThan(Difficulty d) {
            return this.index > d.index;
        }

        public String toString() {
            return this.COLOR.concat(super.toString()).concat(Color.WHITE.toString());
        }
    }
}

