/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.map;

import dangeon.latest.scene.action.Scene_Action;
import dangeon.latest.scene.action.menu.first.adventure.medal.Medal;
import dangeon.model.condition.CONDITION;
import dangeon.model.map.InitialPlacement;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u7f60\u5e2b;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.npc.\u5b88\u77e2\u8cfd\u92ad\u7bb1;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import dangeon.view.anime.DoronEffect;
import dangeon.view.detail.MainMap;
import dangeon.view.detail.MiniMap;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Serializable;
import main.res.SE;
import main.util.DIRECTION;
import main.util.EX_DIRECTION;
import main.util.Show;

public class Mass
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean visible = false;
    private boolean digged;
    private boolean holy;
    private boolean shop;
    private int warning;
    public final boolean HAP;
    public boolean ROOM;
    public boolean WALKABLE;
    public boolean ROAD;
    public boolean DIGGABLE;
    public boolean WATER;
    public boolean WATER_NOT_FROZEN;
    public boolean WATER_LEEF;
    public boolean WATER_FROZEN;
    public boolean FLOWER;
    public final int X;
    public final int Y;
    public Point null_point;
    public static Mass nullpo = new Mass();
    private EX_DIRECTION u_l = null;
    private EX_DIRECTION u_r = null;
    private EX_DIRECTION d_l = null;
    private EX_DIRECTION d_r = null;
    private Base_MapObject map_object_in_wall = null;
    private boolean trap_checked;
    private int restore_water_leef_count;
    private boolean flag_island = false;

    Mass() {
        this.X = -10;
        this.Y = -10;
        this.null_point = new Point(this.X, this.Y);
        this.WALKABLE = false;
        this.ROOM = false;
        this.ROAD = false;
        this.DIGGABLE = false;
        this.HAP = false;
    }

    Mass(int x, int y, char symbol) {
        this.X = x;
        this.Y = y;
        if (x == 0 || x >= 39 || y == 0 || y >= 29) {
            this.WALKABLE = false;
            this.DIGGABLE = false;
            this.ROOM = false;
            this.ROAD = false;
            this.WATER = false;
        } else {
            this.WALKABLE = true;
            this.DIGGABLE = true;
            this.ROOM = false;
            this.ROAD = false;
            this.WATER = false;
            switch (symbol) {
                case '\u58c1': {
                    this.WALKABLE = false;
                    this.DIGGABLE = PresentField.get().isDiggable();
                    break;
                }
                case '\u25a0': {
                    this.WALKABLE = false;
                    this.DIGGABLE = false;
                    break;
                }
                case '\u3000': {
                    this.ROOM = true;
                    break;
                }
                case '\u2606': {
                    this.ROAD = true;
                    break;
                }
                case '\u6c34': {
                    this.WATER = true;
                    this.ROAD = true;
                    break;
                }
                default: {
                    Show.showCriticalErrorMessageDialog("SyntacError : map\u30d5\u30a1\u30a4\u30eb\u306f\u534a\u89d2\u306e\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8\u3068\u4e00\u90e8\u8a18\u53f7\uff08\\.*%+#\uff09\u306e\u307f\u3092\u8a31\u53ef\u3057\u3066\u3044\u307e\u3059\u3002 => ".concat(Character.toString(symbol)));
                }
            }
        }
        this.HAP = Math.floor(new R().nextDouble() * 20.0) % 20.0 == 0.0;
        this.trap_checked = \u5370\u7f60\u5e2b.effect();
    }

    public void drawGrid(Graphics2D g, int x, int y, int size) {
        if (this.WATER) {
            g.setColor(new Color(100, 150, 200));
            g.drawRoundRect(x + 2, y + 2, size - 4, size - 4, size / 8, size / 8);
        } else {
            this.drawGrid_WALKABLE(g, x, y, size);
        }
    }

    private void drawGrid_WALKABLE(Graphics2D g, int x, int y, int size) {
        g.setColor(new Color(160, 170, 130));
        g.drawRect(x + 2, y + 2, size - 4, size - 4);
    }

    public void forceToWater(boolean on) {
        this.WATER = on;
        if (on) {
            this.setUnWarning();
            MapList.water(MapList.getArtiface(this.X, this.Y));
        } else {
            this.WATER_FROZEN = false;
            this.WATER_LEEF = false;
            this.WATER_NOT_FROZEN = false;
        }
        this.WALKABLE = false;
        this.setDigged(true);
    }

    public Mass get(DIRECTION d) {
        return MassCreater.getMass(this.X + d.X, this.Y + d.Y);
    }

    public Point getPoint() {
        return new Point(this.X, this.Y);
    }

    public String getView() {
        String mass = "";
        if (!this.visible) {
            return mass;
        }
        if (this.WALKABLE) {
            mass = "\u25a0";
        }
        return mass;
    }

    public EX_DIRECTION getWallDIRECION(int index) {
        switch (index) {
            case 0: {
                return this.u_l;
            }
            case 1: {
                return this.d_l;
            }
            case 2: {
                return this.u_r;
            }
            case 3: {
                return this.d_r;
            }
        }
        return null;
    }

    public boolean isAbleToExistArtifact() {
        return this.WALKABLE && !this.WATER;
    }

    private boolean isAnyWater_Leef_Frozen() {
        return this.WATER || this.WATER_LEEF || this.WATER_FROZEN;
    }

    public boolean isDiggable() {
        return this.DIGGABLE;
    }

    public boolean isDigged() {
        return this.digged;
    }

    public boolean isHoly() {
        return this.holy;
    }

    public boolean isIsLand() {
        return this.flag_island;
    }

    public boolean isNotPermittedToExistTrapAppearently() {
        if (!this.WALKABLE || this.WATER || this.WATER_LEEF) {
            return true;
        }
        DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyBasic4();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (MassCreater.getMass((int)(this.X + d.X), (int)(this.Y + d.Y)).ROAD) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isObjectInWall() {
        return this.map_object_in_wall != null;
    }

    public boolean isRoom() {
        return this.ROOM;
    }

    public boolean isShop() {
        return this.shop;
    }

    public boolean isTrapChecked() {
        return this.trap_checked;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isWalkable() {
        return this.WALKABLE;
    }

    public boolean isWarning() {
        return this.warning != 0;
    }

    public boolean isWarningLarge(boolean main) {
        if (main) {
            return this.warning == 2;
        }
        return this.warning > 0;
    }

    public boolean isWarningSmall(boolean main) {
        if (main) {
            return this.warning == -2;
        }
        return this.warning < 0;
    }

    public boolean isWater_or_WaterLeef() {
        return this.WATER || this.WATER_LEEF;
    }

    public void setChecked(boolean b) {
        this.trap_checked = b;
    }

    public void setDigged(boolean f) {
        block9: {
            if (f) {
                if (this.WALKABLE) {
                    return;
                }
                if (this.DIGGABLE) {
                    this.tellBroken();
                    InitialPlacement.Room room = MassCreater.getRoom(this.X, this.Y);
                    if (room == null) {
                        this.ROOM = false;
                        this.ROAD = true;
                    } else {
                        this.ROOM = true;
                        this.ROAD = false;
                    }
                    this.WALKABLE = true;
                    int i = -1;
                    while (i <= 1) {
                        int j = -1;
                        while (j <= 1) {
                            if (MassCreater.getMass(this.X + i, this.Y + j).isVisible()) {
                                this.visible = true;
                                break block9;
                            }
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    return;
                }
            }
        }
        this.digged = f;
    }

    private EX_DIRECTION setDOWN_LEFT(boolean RIGHT, boolean LEFT, boolean DOWN, boolean UP, boolean ANGLE) {
        if (DOWN && LEFT) {
            return EX_DIRECTION.DOWN_LEFT;
        }
        if (LEFT) {
            if (UP) {
                return EX_DIRECTION.UP_LEFT;
            }
            return EX_DIRECTION.LEFT;
        }
        if (DOWN) {
            if (RIGHT) {
                return EX_DIRECTION.DOWN_RIGHT;
            }
            return EX_DIRECTION.DOWN;
        }
        if (ANGLE) {
            return EX_DIRECTION.ELSE;
        }
        if (UP && RIGHT) {
            return EX_DIRECTION.UP_RIGHT;
        }
        if (RIGHT) {
            return EX_DIRECTION.RIGHT;
        }
        if (UP) {
            return EX_DIRECTION.UP;
        }
        return EX_DIRECTION.NEUTRAL;
    }

    private EX_DIRECTION setDOWN_RIGHT(boolean LEFT, boolean RIGHT, boolean UP, boolean DOWN, boolean ANGLE) {
        if (DOWN && RIGHT) {
            return EX_DIRECTION.DOWN_RIGHT;
        }
        if (RIGHT) {
            if (UP) {
                return EX_DIRECTION.UP_RIGHT;
            }
            return EX_DIRECTION.RIGHT;
        }
        if (DOWN) {
            if (LEFT) {
                return EX_DIRECTION.DOWN_LEFT;
            }
            return EX_DIRECTION.DOWN;
        }
        if (ANGLE) {
            return EX_DIRECTION.ELSE;
        }
        if (UP && LEFT) {
            return EX_DIRECTION.UP_LEFT;
        }
        if (LEFT) {
            return EX_DIRECTION.LEFT;
        }
        if (UP) {
            return EX_DIRECTION.UP;
        }
        return EX_DIRECTION.NEUTRAL;
    }

    public void setFrozen(boolean b) {
        if (b == this.isWater_or_WaterLeef()) {
            this.setWater(!b);
            this.WATER_FROZEN = b;
            this.WATER_LEEF = false;
            if (this.WATER_FROZEN && EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.ALL, ENCHANT_SIMBOL.\u51b4)) {
                SE.LIGHT_ON.play();
                Scene_Action.getMe().tellRestStop();
                Player.me.setCondition(CONDITION.\u76ee\u85ac, 0);
            }
        }
    }

    public void setFrozen_includingNeibors() {
        this.setFrozen(true);
        DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyBasic4();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            Mass m = MassCreater.getMass(this.getPoint(), d);
            if (m.isWater_or_WaterLeef()) {
                m.setFrozen_includingNeibors();
            }
            ++n2;
        }
    }

    public void setHoly(boolean f) {
        this.holy = f;
    }

    public void setIsLand(boolean b) {
        this.flag_island = b;
    }

    public void setLeef() {
        if (new R().is(10) && !MapList.isCreature(this.getPoint())) {
            this.WATER = false;
            this.WATER_LEEF = true;
            if (new R().is(10)) {
                this.FLOWER = true;
            }
        } else {
            this.WATER_LEEF = false;
        }
    }

    public void setNonFrozenWater() {
        this.WATER_NOT_FROZEN = true;
        this.setWater(true);
    }

    public void setObjectInWall(Base_MapObject mapObject) {
        if (!this.WALKABLE && !this.isObjectInWall()) {
            this.map_object_in_wall = mapObject;
        }
    }

    public void setShop(boolean b) {
        this.shop = b;
    }

    public void setUnWarning() {
        if (this.isWarning() && !this.isWarningLarge(true) && !this.isWarningSmall(true)) {
            this.warning = 0;
            MassCreater.retakeMassSet();
        }
    }

    private EX_DIRECTION setUP_LEFT(boolean RIGHT, boolean LEFT, boolean UP, boolean DOWN, boolean ANGLE) {
        if (UP && LEFT) {
            return EX_DIRECTION.UP_LEFT;
        }
        if (LEFT) {
            if (DOWN) {
                return EX_DIRECTION.DOWN_LEFT;
            }
            return EX_DIRECTION.LEFT;
        }
        if (UP) {
            if (RIGHT) {
                return EX_DIRECTION.UP_RIGHT;
            }
            return EX_DIRECTION.UP;
        }
        if (ANGLE) {
            return EX_DIRECTION.ELSE;
        }
        if (DOWN && RIGHT) {
            return EX_DIRECTION.DOWN_RIGHT;
        }
        if (RIGHT) {
            return EX_DIRECTION.RIGHT;
        }
        if (DOWN) {
            return EX_DIRECTION.DOWN;
        }
        return EX_DIRECTION.NEUTRAL;
    }

    private EX_DIRECTION setUP_RIGHT(boolean LEFT, boolean RIGHT, boolean UP, boolean DOWN, boolean ANGLE) {
        if (UP && RIGHT) {
            return EX_DIRECTION.UP_RIGHT;
        }
        if (RIGHT) {
            if (DOWN) {
                return EX_DIRECTION.DOWN_RIGHT;
            }
            return EX_DIRECTION.RIGHT;
        }
        if (UP) {
            if (LEFT) {
                return EX_DIRECTION.UP_LEFT;
            }
            return EX_DIRECTION.UP;
        }
        if (ANGLE) {
            return EX_DIRECTION.ELSE;
        }
        if (DOWN && LEFT) {
            return EX_DIRECTION.DOWN_LEFT;
        }
        if (LEFT) {
            return EX_DIRECTION.LEFT;
        }
        if (DOWN) {
            return EX_DIRECTION.DOWN;
        }
        return EX_DIRECTION.NEUTRAL;
    }

    public void setVisible(boolean f) {
        this.visible = f;
    }

    private void setWall() {
        Mass[][] mass = MassCreater.getMass();
        boolean LEFT = false;
        boolean RIGHT = false;
        boolean UP = false;
        boolean DOWN = false;
        try {
            LEFT = mass[this.X - 1][this.Y].WALKABLE;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            RIGHT = mass[this.X + 1][this.Y].WALKABLE;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            UP = mass[this.X][this.Y - 1].WALKABLE;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            DOWN = mass[this.X][this.Y + 1].WALKABLE;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.u_r = this.setUP_RIGHT(LEFT, RIGHT, UP, DOWN, mass[this.X + 1][this.Y - 1].WALKABLE);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.u_r = this.setUP_RIGHT(LEFT, RIGHT, UP, DOWN, false);
        }
        try {
            this.u_l = this.setUP_LEFT(RIGHT, LEFT, UP, DOWN, mass[this.X - 1][this.Y - 1].WALKABLE);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.u_l = this.setUP_LEFT(RIGHT, LEFT, UP, DOWN, false);
        }
        try {
            this.d_r = this.setDOWN_RIGHT(LEFT, RIGHT, UP, DOWN, mass[this.X + 1][this.Y + 1].WALKABLE);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.d_r = this.setDOWN_RIGHT(LEFT, RIGHT, UP, DOWN, false);
        }
        try {
            this.d_l = this.setDOWN_LEFT(RIGHT, LEFT, DOWN, UP, mass[this.X - 1][this.Y + 1].WALKABLE);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.d_l = this.setDOWN_LEFT(RIGHT, LEFT, DOWN, UP, false);
        }
    }

    void setWallTileNo() {
        if (this.WATER || this.WATER_FROZEN || this.WATER_LEEF) {
            this.setWater();
        } else if (!this.WALKABLE) {
            this.setWall();
        }
    }

    public void setWarningLarge(boolean b) {
        if (b) {
            if (!this.isWarningLarge(false)) {
                this.warning = 2;
            }
        } else if (!this.isNotPermittedToExistTrapAppearently()) {
            this.warning = 1;
        }
    }

    public void setWarningSmall(boolean b) {
        if (b) {
            if (!this.isWarningSmall(false)) {
                this.warning = -2;
            }
        } else if (!this.isNotPermittedToExistTrapAppearently()) {
            this.warning = -1;
        }
    }

    private void setWater() {
        this.ROOM = MassCreater.getRoom(this.X, this.Y) != null;
        Mass[][] mass = MassCreater.getMass();
        boolean LEFT = false;
        boolean RIGHT = false;
        boolean UP = false;
        boolean DOWN = false;
        try {
            LEFT = !mass[this.X - 1][this.Y].isAnyWater_Leef_Frozen();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            RIGHT = !mass[this.X + 1][this.Y].isAnyWater_Leef_Frozen();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            UP = !mass[this.X][this.Y - 1].isAnyWater_Leef_Frozen();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            DOWN = !mass[this.X][this.Y + 1].isAnyWater_Leef_Frozen();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.u_r = this.setUP_RIGHT(LEFT, RIGHT, UP, DOWN, !mass[this.X + 1][this.Y - 1].isAnyWater_Leef_Frozen());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.u_r = this.setUP_RIGHT(LEFT, RIGHT, UP, DOWN, false);
        }
        try {
            this.u_l = this.setUP_LEFT(RIGHT, LEFT, UP, DOWN, !mass[this.X - 1][this.Y - 1].isAnyWater_Leef_Frozen());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.u_l = this.setUP_LEFT(RIGHT, LEFT, UP, DOWN, false);
        }
        try {
            this.d_r = this.setDOWN_RIGHT(LEFT, RIGHT, UP, DOWN, !mass[this.X + 1][this.Y + 1].isAnyWater_Leef_Frozen());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.d_r = this.setDOWN_RIGHT(LEFT, RIGHT, UP, DOWN, false);
        }
        try {
            this.d_l = this.setDOWN_LEFT(RIGHT, LEFT, DOWN, UP, !mass[this.X - 1][this.Y + 1].isAnyWater_Leef_Frozen());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.d_l = this.setDOWN_LEFT(RIGHT, LEFT, DOWN, UP, false);
        }
    }

    public void setWater(boolean on) {
        if (!this.DIGGABLE) {
            return;
        }
        this.WATER = on;
        if (on) {
            this.setUnWarning();
            MapList.water(MapList.getArtiface(this.X, this.Y));
        }
        if (on && !this.WATER_NOT_FROZEN) {
            this.setLeef();
        }
        this.WALKABLE = false;
        this.setDigged(true);
    }

    public void setWaterLeefOn(boolean walk_off) {
        this.forceToWater(walk_off);
        boolean bl = this.WATER_LEEF = !walk_off;
        if (walk_off) {
            int x = new R().nextInt(20) + 2;
            this.restore_water_leef_count = (int)(Math.pow(10.0, -1.0 / (double)x) * 10.0) - 1;
            Base_Artifact a = MapList.getArtifact(this.getPoint());
            if (a != null) {
                a.waterAction();
            }
        } else {
            this.restore_water_leef_count = 0;
            this.FLOWER = false;
        }
        MiniMap.reset();
    }

    public void setWaterWithAnimation(boolean on, boolean last) {
        if (this.WATER != on) {
            SE.ATTACK_WATER.play();
            MainMap.addEffect(new DoronEffect(new Point(this.X, this.Y), null, true, false), true);
            this.forceToWater(on);
            if (last) {
                MassCreater.retakeMassSet();
            }
        }
    }

    public void stepEnd() {
        if (this.restore_water_leef_count > 0 && --this.restore_water_leef_count == 0 && this.WATER) {
            this.setWaterLeefOn(false);
        }
    }

    public void tellBroken() {
        if (this.isObjectInWall()) {
            if (this.map_object_in_wall instanceof Base_Artifact) {
                MapList.addArtifact((Base_Artifact)this.map_object_in_wall);
            } else if (this.map_object_in_wall instanceof Base_Enemy) {
                if (this.map_object_in_wall instanceof \u5b88\u77e2\u8cfd\u92ad\u7bb1) {
                    SE.FANFARE1.play();
                    Medal.\u58c1\u306e\u4e2d\u304b\u3089\u8cfd\u92ad\u7bb1\u3092\u767a\u898b\u3057\u305f.addCount();
                }
                MapList.addEnemy((Base_Enemy)this.map_object_in_wall);
            }
        }
    }
}

