/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.map;

import dangeon.controller.TurnSystemController;
import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.config.table.EnemyTable;
import dangeon.model.map.InitialPlacement;
import dangeon.model.map.ItemFall;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.Base_Device;
import dangeon.model.object.artifact.device.Stairs;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.food.Food;
import dangeon.model.object.artifact.item.food.\u5947\u8de1\u306e\u304a\u306b\u304e\u308a;
import dangeon.model.object.artifact.item.food.\u8150\u3063\u305f\u304a\u306b\u304e\u308a;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.artifact.trap.Base_Trap;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.enemy.\u3086\u3063\u304f\u308a\u970a\u5922;
import dangeon.model.object.creature.enemy.\u308f\u304b\u3055\u304e\u59eb;
import dangeon.model.object.creature.enemy.\u7269\u90e8\u5e03\u90fd;
import dangeon.model.object.creature.npc.Base_NPC;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.class_job.bonus.bonus_switch.BonusConductor;
import dangeon.util.ObjectPoint;
import dangeon.util.R;
import dangeon.view.anime.Base_Anime;
import dangeon.view.anime.DoronEffect;
import dangeon.view.detail.MainMap;
import dangeon.view.detail.View_Sider;
import dangeon.view.util.WithinOutofScreen;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import main.res.BGM;
import main.res.SE;
import main.util.DIRECTION;
import main.util.FrameShaker;

public class MapList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static List<Base_Enemy> list_room_in_enemy = new ArrayList<Base_Enemy>();
    private static List<Base_Creature> list_room_in_creature = new ArrayList<Base_Creature>();
    private static List<Base_Creature> list_around_creature = new ArrayList<Base_Creature>();
    private static List<Base_Enemy> list_enemy = new ArrayList<Base_Enemy>();
    private static List<Base_Artifact> list_artifact = new ArrayList<Base_Artifact>();
    public static MapList ME = new MapList();
    private static final int MAX_MASS = 50;
    private static final int ENEMY_MAX = 30;
    private static boolean[][] check_room = new boolean[50][50];
    public static Point stairs_point;
    private static boolean flag_sheef_start;
    private static boolean flag_holy_in;
    private static boolean flag_shop_in;
    private static ArrayList<Mass> huto_waters;
    private static boolean next_floor_asc;
    private static ArrayList<Mass> leef_task;
    private int floor = 0;

    static {
        flag_sheef_start = false;
        flag_holy_in = false;
        flag_shop_in = false;
        next_floor_asc = true;
        leef_task = new ArrayList();
    }

    public static void addAroundCreature(Point p) {
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                if ((i != 0 || j != 0) && MapList.getCreature(p.x + i, p.y + j) != null) {
                    list_around_creature.add(MapList.getCreature(p.x + i, p.y + j));
                }
                ++j;
            }
            ++i;
        }
    }

    public static synchronized void addArtifact(Base_Artifact af) {
        if (af == null) {
            return;
        }
        if (!list_artifact.contains(af)) {
            if (af instanceof Base_Trap && MapList.getArtifact(af.getMassPoint()) != null) {
                return;
            }
            Mass mass = MassCreater.getMass(af.getMassPoint());
            mass.setUnWarning();
            if (BonusConductor.\u5b88\u77e2\u795e() && af instanceof Food && !(af instanceof \u5947\u8de1\u306e\u304a\u306b\u304e\u308a)) {
                \u5947\u8de1\u306e\u304a\u306b\u304e\u308a a = new \u5947\u8de1\u306e\u304a\u306b\u304e\u308a((Food)af);
                list_artifact.add(a);
                return;
            }
            if (mass.WATER && !af.waterAction()) {
                return;
            }
            list_artifact.add(af);
        }
    }

    public static synchronized boolean addEnemy(Base_Enemy em) {
        if (MapList.isEnemyMax()) {
            return false;
        }
        if (MassCreater.getMass((Point)em.getMassPoint()).WATER && !em.isWatering()) {
            return false;
        }
        em.setSize();
        list_enemy.add(em);
        return true;
    }

    public static void addRoomInCreature(int x, int y) {
        Mass[][] mass = MassCreater.getMass();
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                if (!(i == 0 && j == 0 || check_room[x + i][y + j])) {
                    if (mass[x + i][y + j].ROAD || !mass[x + i][y + j].WALKABLE) {
                        MapList.check_room[x + i][y + j] = true;
                    } else if (MapList.getCreature(x + i, y + j) != null) {
                        MapList.check_room[x + i][y + j] = true;
                        list_room_in_creature.add(MapList.getCreature(x + i, y + j));
                    } else if (mass[x + i][y + j].ROOM) {
                        MapList.check_room[x + i][y + j] = true;
                        MapList.addRoomInCreature(x + i, y + j);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void addRoomInEnemy(int x, int y) {
    }

    public static void ascFloor() {
        ++MapList.ME.floor;
    }

    public static void awaken() {
        for (Base_Enemy em : MapList.getListEnemy()) {
            CONDITION.conditionRecovery(em, CONDITION.\u4eee\u7720);
            if (!EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u5fcd)) {
                CONDITION.conditionRecovery(em, CONDITION.\u7279\u6b8a\u4eee\u7720);
                CONDITION.conditionRecovery(em, CONDITION.\u5b89\u5fc3);
            }
            for (CONDITION con : em.getConditionRemoveTask()) {
                em.getConditionList().remove((Object)con);
            }
            em.getConditionRemoveTask().clear();
        }
    }

    public static void check_mass_clear() {
        int i = 0;
        while (i < 50) {
            int j = 0;
            while (j < 50) {
                MapList.check_room[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public static boolean checkSpecialRoom(Point p) {
        Mass m = MassCreater.getMass(p);
        if (flag_shop_in && Player.me.shop != null) {
            if (!m.isShop()) {
                flag_shop_in = false;
                Player.me.shop.getTenshu().goOutMessage();
            } else {
                Player.me.shop.preGoOut();
            }
        }
        if (flag_holy_in && Player.me.saisen != null && !m.isHoly()) {
            Player.me.saisen.goOut();
            flag_holy_in = false;
        }
        InitialPlacement.Room r = MassCreater.getIP().getRoom(p);
        int lv = MapList.isHutoChan(r);
        if (huto_waters != null && lv == -1) {
            MapList.hutoOut();
        }
        if (r == null) {
            return false;
        }
        if (r.flag_monster_house) {
            r.flag_monster_house = false;
            MapList.performMonsterHosue();
            return true;
        }
        if (!flag_shop_in && m.isShop()) {
            flag_shop_in = true;
            if (Player.me.shop != null) {
                Player.me.shop.getTenshu().shopInMessage();
            }
        }
        if (!flag_holy_in && m.isHoly()) {
            flag_holy_in = true;
            if (Player.me.saisen != null) {
                Message.set("\u5fa1\u6bbf\u306b\u8db3\u3092\u8e0f\u307f\u5165\u308c\u305f");
            }
        }
        if (huto_waters == null && lv != -1) {
            MapList.hutoIN(r, lv);
        }
        MapList.checkWater();
        return false;
    }

    public static void checkWater() {
        List<Base_Creature> list = MapList.getListCreature();
        list.add(Player.me);
        Iterator<Mass> iterator = leef_task.iterator();
        while (iterator.hasNext()) {
            Mass _M = iterator.next();
            if (MapList.isCreature(_M.getPoint())) continue;
            _M.setWaterLeefOn(true);
            iterator.remove();
        }
        for (Base_Creature c : list) {
            Mass m = MassCreater.getMass(c.getMassPoint());
            if (m.WATER_LEEF && !leef_task.contains(m)) {
                leef_task.add(m);
                if (m.FLOWER && c instanceof Player) {
                    c.heal(null, c.getMAX_HP());
                }
            }
            if (c.isAnimating()) continue;
            if (m.WATER) {
                c.waterAction(m);
                continue;
            }
            if (!(c instanceof \u308f\u304b\u3055\u304e\u59eb)) continue;
            SE.ATTACK_WATER.play();
            Message.set(c.getColoredName(), "\u306f\u5730\u4e0a\u3067\u306f\u6d3b\u52d5\u3067\u304d\u306a\u3044\uff01");
            c.chengeHP_NoEffect(-999);
        }
    }

    public static void clear() {
        flag_shop_in = false;
        list_enemy.clear();
        list_artifact.clear();
    }

    public static void desFloor() {
        --MapList.ME.floor;
    }

    public static void gatherCheckedItems() {
        ArrayList<Base_Item> list = new ArrayList<Base_Item>();
        for (Base_Artifact a : list_artifact) {
            if (!(a instanceof Base_Item) || !((Base_Item)a).isPickCheked()) continue;
            list.add((Base_Item)a);
        }
        int count = 0;
        boolean flag_max = false;
        for (Base_Item a : list) {
            if (!ItemFall.isAbleToFall_AroundPlayer()) {
                flag_max = true;
                break;
            }
            ++count;
            ItemFall.setItemFallPoint_NoMessage(Player.me.getMassPoint().getLocation(), a);
        }
        if (count > 0) {
            SE.WARP_INSTANT.play();
            Message.set("\u30a2\u30a4\u30c6\u30e0\u3092\u96c6\u3081\u305f");
            TurnSystemController.callMeToStartEnemyTurn();
            if (flag_max) {
                View_Sider.setInformation("\uff01\u5bfe\u8c61\u304c\u591a\u3059\u304e\u3066\u96c6\u3081\u304d\u308c\u3066\u3044\u306a\u3044\uff01");
            }
        } else {
            Message.set("\u5e8a\u304c\u3044\u3063\u3071\u3044\u3067\u30a2\u30a4\u30c6\u30e0\u3092\u96c6\u3081\u3089\u308c\u306a\u304b\u3063\u305f");
        }
    }

    public static ArrayList<Base_Enemy> getAnyEnemyInScreen() {
        ArrayList<Base_Enemy> list = new ArrayList<Base_Enemy>();
        for (Base_Enemy e : list_enemy) {
            Point p = ObjectPoint.getScreenPointRelPlayer(e);
            int x = p.x;
            int y = p.y;
            if (WithinOutofScreen.isOutside(x, y, e.getImage().getWidth(null), e.getImage().getHeight(null))) continue;
            list.add(e);
        }
        return list;
    }

    public static synchronized Base_Artifact getArtiface(int index) {
        return list_artifact.get(index);
    }

    public static synchronized Base_Artifact getArtiface(int x, int y) {
        for (Base_Artifact a : list_artifact) {
            if (a.getMassPoint().x != x || a.getMassPoint().y != y) continue;
            return a;
        }
        return null;
    }

    public static Base_Artifact getArtiface_exceptME(Point p, Base_Artifact artifact) {
        for (Base_Artifact a : list_artifact) {
            if (a.getMassPoint().x != p.x || a.getMassPoint().y != p.y || a == artifact) continue;
            return a;
        }
        return null;
    }

    public static Base_Artifact getArtiface_exceptME_Trap(Point p, Base_Artifact artifact) {
        for (Base_Artifact a : list_artifact) {
            if (a.getMassPoint().x != p.x || a.getMassPoint().y != p.y || a == artifact || a instanceof Base_Trap) continue;
            return a;
        }
        return null;
    }

    public static Base_Artifact getArtifact(Point p) {
        for (Base_Artifact a : list_artifact) {
            if (a.getMassPoint().x != p.x || a.getMassPoint().y != p.y) continue;
            return a;
        }
        return null;
    }

    public static Base_Creature getCreature(int x, int y) {
        return MapList.getCreature(new Point(x, y));
    }

    public static Base_Creature getCreature(Point p) {
        if (Player.me.getMassPoint().x == p.x && Player.me.getMassPoint().y == p.y) {
            return Player.me;
        }
        return MapList.getEnemy(p);
    }

    public static synchronized Base_Enemy getEnemy(int index) {
        return list_enemy.get(index);
    }

    public static synchronized Base_Enemy getEnemy(int x, int y) {
        for (Base_Enemy e : list_enemy) {
            if (e.getMassPoint().x != x || e.getMassPoint().y != y) continue;
            return e;
        }
        return null;
    }

    public static synchronized Base_Enemy getEnemy(Point p) {
        for (Base_Enemy e : list_enemy) {
            if (e.getMassPoint().x != p.x || e.getMassPoint().y != p.y) continue;
            return e;
        }
        return null;
    }

    public static boolean getFlagSheef() {
        return flag_sheef_start;
    }

    public static int getFloor() {
        return MapList.ME.floor;
    }

    public static Base_Enemy getFrontEnemy() {
        Point p = Player.me.getMassPoint();
        switch (Player.me.getDirection()) {
            case UP: {
                if (MapList.getEnemy(p.x, p.y - 1) == null) break;
                return MapList.getEnemy(p.x, p.y - 1);
            }
            case DOWN: {
                if (MapList.getEnemy(p.x, p.y + 1) == null) break;
                return MapList.getEnemy(p.x, p.y + 1);
            }
            case LEFT: {
                if (MapList.getEnemy(p.x - 1, p.y) == null) break;
                return MapList.getEnemy(p.x - 1, p.y);
            }
            case RIGHT: {
                if (MapList.getEnemy(p.x + 1, p.y) == null) break;
                return MapList.getEnemy(p.x + 1, p.y);
            }
            case UP_LEFT: {
                if (MapList.getEnemy(p.x - 1, p.y - 1) == null) break;
                return MapList.getEnemy(p.x - 1, p.y - 1);
            }
            case UP_RIGHT: {
                if (MapList.getEnemy(p.x + 1, p.y - 1) == null) break;
                return MapList.getEnemy(p.x + 1, p.y - 1);
            }
            case DOWN_LEFT: {
                if (MapList.getEnemy(p.x - 1, p.y + 1) == null) break;
                return MapList.getEnemy(p.x - 1, p.y + 1);
            }
            case DOWN_RIGHT: {
                if (MapList.getEnemy(p.x + 1, p.y + 1) == null) break;
                return MapList.getEnemy(p.x + 1, p.y + 1);
            }
        }
        return null;
    }

    public static List<Base_Artifact> getListAroundArtifact(Point p) {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>();
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                Base_Artifact c;
                if ((i != 0 || j != 0) && (c = MapList.getArtiface(p.x + i, p.y + j)) != null) {
                    list.add(c);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static List<Base_Creature> getListAroundCreature() {
        return list_around_creature;
    }

    public static ArrayList<Base_Creature> getListAroundCreature(Point p) {
        ArrayList<Base_Creature> list = new ArrayList<Base_Creature>();
        DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            Point _P = p.getLocation();
            _P.translate(d.X, d.Y);
            if (MapList.getCreature(_P) != null) {
                list.add(MapList.getCreature(_P));
            }
            ++n2;
        }
        return list;
    }

    public static List<Base_Enemy> getListAroundEnemy(Point p) {
        ArrayList<Base_Enemy> list = new ArrayList<Base_Enemy>();
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                Base_Creature c;
                if ((i != 0 || j != 0) && (c = MapList.getCreature(p.x + i, p.y + j)) != null && c instanceof Base_Enemy && !(c instanceof Base_NPC)) {
                    list.add((Base_Enemy)c);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static synchronized List<Base_Artifact> getListArtifact() {
        return list_artifact;
    }

    public static List<Base_Creature> getListCreature() {
        int sum = list_enemy.size();
        ArrayList<Base_Creature> l = new ArrayList<Base_Creature>(sum);
        for (Base_Creature base_Creature : list_enemy) {
            l.add(base_Creature);
        }
        return l;
    }

    public static synchronized List<Base_Enemy> getListEnemy() {
        return list_enemy;
    }

    public static synchronized List<Base_Artifact> getListItem() {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>();
        for (Base_Artifact a : list_artifact) {
            if (!(a instanceof Base_Item)) continue;
            list.add(a);
        }
        return list;
    }

    public static synchronized List<Base_Enemy> getListNpc() {
        ArrayList<Base_Enemy> list = new ArrayList<Base_Enemy>();
        for (Base_Enemy em : MapList.getListEnemy()) {
            if (!(em instanceof Base_NPC)) continue;
            list.add(em);
        }
        return list;
    }

    public static List<Base_Creature> getListRoomInCreature() {
        return list_room_in_creature;
    }

    public static List<Base_Enemy> getListRoomInEnemy() {
        return list_room_in_enemy;
    }

    public static Base_Enemy getNonActionedEnemu() {
        for (Base_Enemy enemy : MapList.getListEnemy()) {
            if (enemy.enemy_actioned) continue;
            return enemy;
        }
        return null;
    }

    public static synchronized Base_NPC getNpc(Point p) {
        for (Base_Enemy npc : MapList.getListEnemy()) {
            if (!(npc instanceof Base_NPC) || npc.getMassPoint().x != p.x || npc.getMassPoint().y != p.y) continue;
            return (Base_NPC)npc;
        }
        return null;
    }

    private static int getPermittedValue(Mass m) {
        if (m.WATER || m.WATER_FROZEN) {
            return 1;
        }
        if (!m.WALKABLE) {
            return 2;
        }
        if (m.ROAD || MapList.getArtifact(new Point(m.X, m.Y)) instanceof Base_Trap) {
            return 1;
        }
        if (MassCreater.getRoom(m.X, m.Y) == null != m.ROAD) {
            System.out.println("NOT_ROAD_MISMATCH");
        }
        return 0;
    }

    private static int getPermittedValue(Mass m, DIRECTION d) {
        return MapList.getPermittedValue(MassCreater.getMass(m.getPoint(), d));
    }

    public static Stairs getStairs() {
        for (Base_Artifact a : list_artifact) {
            if (!(a instanceof Stairs)) continue;
            return (Stairs)a;
        }
        return null;
    }

    public static ArrayList<Base_Creature> getSurroundedCreature(Point p) {
        ArrayList<Base_Creature> list = new ArrayList<Base_Creature>();
        DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            Base_Creature c = MapList.getCreature(p.x + d.X, p.y + d.Y);
            if (c != null) {
                list.add(c);
            }
            ++n2;
        }
        return list;
    }

    public static ArrayList<Base_Creature> getSurroundedCreature_IncludingMyself(Point p) {
        ArrayList<Base_Creature> list = new ArrayList<Base_Creature>();
        DIRECTION[] dIRECTIONArray = DIRECTION.values();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            Base_Creature c = MapList.getCreature(p.x + d.X, p.y + d.Y);
            if (c != null) {
                list.add(c);
            }
            ++n2;
        }
        return list;
    }

    public static Base_Trap getTrap(Point p) {
        if (MapList.getArtifact(p) != null && MapList.getArtifact(p) instanceof Base_Trap) {
            return (Base_Trap)MapList.getArtifact(p);
        }
        return null;
    }

    private static void hutoIN(InitialPlacement.Room r, int lv) {
        huto_waters = r.setHuto(lv);
    }

    private static void hutoOut() {
        Iterator<Mass> iterator = huto_waters.iterator();
        while (iterator.hasNext()) {
            iterator.next().setWaterWithAnimation(false, !iterator.hasNext());
        }
        Message.set("\u79d8\u8853\u304b\u3089\u89e3\u653e\u3055\u308c\u305f");
        huto_waters = null;
    }

    public static boolean isAnyEnemyInScreen() {
        for (Base_Enemy e : list_enemy) {
            if (!MapList.isAnyEnemyInScreen_Check(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyEnemyInScreen_Check(Base_Enemy e) {
        CONDITION[] cs;
        if (e == null) {
            return false;
        }
        if (e instanceof Base_NPC) {
            return false;
        }
        if (e.isPlayerSide()) {
            return false;
        }
        CONDITION[] cONDITIONArray = cs = new CONDITION[]{CONDITION.\u7761\u7720, CONDITION.\u6697\u95c7, CONDITION.\u5b89\u5fc3, CONDITION.\u4eee\u7720, CONDITION.\u7279\u6b8a\u4eee\u7720, CONDITION.\u9ebb\u75fa, CONDITION.\u5f71\u7e2b\u3044};
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            CONDITION condition = cONDITIONArray[n2];
            if (e.conditionCheck(condition)) {
                return false;
            }
            ++n2;
        }
        Point p = ObjectPoint.getScreenPointRelPlayer(e);
        int x = p.x;
        int y = p.y;
        return !WithinOutofScreen.isOutside(x, y, e.getImage().getWidth(null), e.getImage().getHeight(null));
    }

    public static boolean isAnyEnemyStatusQuickInScreen() {
        for (Base_Enemy e : MapList.getAnyEnemyInScreen()) {
            if (!e.conditionCheck(CONDITION.\u500d\u901f) && !e.conditionCheck(CONDITION.\u4e09\u500d\u901f)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnything(int x, int y) {
        return MapList.isArtifact(x, y) || MapList.isCreature(x, y);
    }

    public static boolean isArtifact(int x, int y) {
        return MapList.getArtifact(new Point(x, y)) != null;
    }

    public static boolean isCheckedItem() {
        for (Base_Artifact a : list_artifact) {
            if (!(a instanceof Base_Item) || !((Base_Item)a).isPickCheked()) continue;
            return true;
        }
        return false;
    }

    public static boolean isCreature(int x, int y) {
        return MapList.getCreature(x, y) != null;
    }

    public static boolean isCreature(Point point) {
        return MapList.isCreature(point.x, point.y);
    }

    public static boolean isCreatureAnimating() {
        if (Player.me.isAnimating()) {
            return true;
        }
        return !MapList.isEnemyAnimatigEnded();
    }

    public static boolean isEnemyAnimatigEnded() {
        for (Base_Enemy enemy : MapList.getListEnemy()) {
            if (!enemy.isAnimating()) continue;
            enemy.isAnimating();
            return false;
        }
        for (Base_Artifact a : MapList.getListArtifact()) {
            if (!a.isAnimating()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnemyMax() {
        return list_enemy.size() >= 30;
    }

    private static int isHutoChan(InitialPlacement.Room r) {
        if (r == null) {
            return -1;
        }
        for (Base_Enemy em : MapList.getListEnemy()) {
            if (!(em instanceof \u7269\u90e8\u5e03\u90fd) || !em.isSkillActive()) continue;
            em.whereIsPlayer();
            if (!em.player_is_in_sight) continue;
            return em.getLV();
        }
        return -1;
    }

    public static boolean isNeiboringToRoad(int x, int y) {
        DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyBasic4();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (MassCreater.getMass((int)(x + d.X), (int)(y + d.Y)).ROAD) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isNextFloorUpOrDown() {
        return next_floor_asc;
    }

    public static Base_Enemy isSearchEnemyInClass(String str) {
        for (Base_Enemy em : list_enemy) {
            if (!em.getClass().getSimpleName().matches(str)) continue;
            return em;
        }
        return null;
    }

    private static boolean isTrapOrWaterPermitted(ArrayList<Mass> checked, ArrayList<Mass> around, Mass me) {
        if (around.isEmpty()) {
            return true;
        }
        if (MapList.isTrapOrWaterPermitted(around.get(0), around.get(0), checked, around, me)) {
            around.remove(0);
            return MapList.isTrapOrWaterPermitted(checked, around, me);
        }
        return false;
    }

    public static boolean isTrapOrWaterPermitted(int x, int y) {
        if (!MassCreater.getMass((int)x, (int)y).WALKABLE) {
            return true;
        }
        if (MapList.isNeiboringToRoad(x, y)) {
            return false;
        }
        Base_Artifact a = MapList.getArtiface(x, y);
        if (a != null && a instanceof Base_Device) {
            return false;
        }
        ArrayList<Mass> checked = new ArrayList<Mass>();
        ArrayList<Mass> around = new ArrayList<Mass>(4);
        Mass me = MassCreater.getMass(x, y);
        checked.add(Mass.nullpo);
        checked.add(me);
        DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyBasic4();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            Mass m = MassCreater.getMass(x + d.X, y + d.Y);
            if (MapList.getPermittedValue(m) != 0) {
                around.add(m);
            }
            ++n2;
        }
        return MapList.isTrapOrWaterPermitted(checked, around, me);
    }

    private static boolean isTrapOrWaterPermitted(Mass now, Mass START, ArrayList<Mass> checked, ArrayList<Mass> around, Mass CHECK) {
        int n;
        DIRECTION[] ds;
        checked.add(now);
        int v = MapList.getPermittedValue(now);
        if (v == 1) {
            ds = DIRECTION.values_onlyBasic4();
        } else if (v == 2) {
            boolean wall_in_wall = true;
            DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyBasic4();
            int n2 = dIRECTIONArray.length;
            n = 0;
            while (n < n2) {
                DIRECTION d = dIRECTIONArray[n];
                if (MapList.getPermittedValue(MassCreater.getMass(now.X + d.X, now.Y + d.Y)) != 2) {
                    wall_in_wall = false;
                    break;
                }
                ++n;
            }
            if (wall_in_wall) {
                return true;
            }
            ds = DIRECTION.values_exceptNeatral();
        } else {
            return true;
        }
        DIRECTION[] dIRECTIONArray = ds;
        n = ds.length;
        int n3 = 0;
        while (n3 < n) {
            DIRECTION d = dIRECTIONArray[n3];
            Mass mass = MassCreater.getMass(now.X + d.X, now.Y + d.Y);
            if (mass == CHECK ? !MapList.isTrapOrWaterPermitted(now, START, CHECK) : !checked.contains(mass) && !MapList.isTrapOrWaterPermitted(mass, START, checked, around, CHECK)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static boolean isTrapOrWaterPermitted(Mass end, Mass start, Mass check) {
        DIRECTION d_s = DIRECTION.getDirection(check.getPoint(), start.getPoint());
        DIRECTION d_e = DIRECTION.getDirection(check.getPoint(), end.getPoint());
        int dx = Math.abs(end.X - start.X);
        int dy = Math.abs(end.Y - start.Y);
        if (end == start) {
            return true;
        }
        if (dx == 1 || dy == 1) {
            if (dx == 0 || dy == 0) {
                return true;
            }
            if (MapList.getPermittedValue(end) == 2 || MapList.getPermittedValue(start) == 2) {
                return true;
            }
            if (MapList.getPermittedValue(check, DIRECTION.getSum(d_s, d_e)) != 0) {
                return true;
            }
            DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
            int n = dIRECTIONArray.length;
            int n2 = 0;
            while (n2 < n) {
                DIRECTION d = dIRECTIONArray[n2];
                if (d != d_s && d != d_e && d != DIRECTION.getSum(d_s, d_e) && MapList.isTrapOrWaterPermitted_isWakable(d, check)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        int c = 0;
        DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
        int n = dIRECTIONArray.length;
        int n3 = 0;
        while (n3 < n) {
            DIRECTION d = dIRECTIONArray[n3];
            if (MapList.isTrapOrWaterPermitted_isWakable(d, check)) {
                ++c;
            }
            ++n3;
        }
        return c < 2;
    }

    public static boolean isTrapOrWaterPermitted(Point p) {
        return MapList.isTrapOrWaterPermitted(p.x, p.y);
    }

    private static boolean isTrapOrWaterPermitted_isWakable(DIRECTION d, Mass goal) {
        return MapList.isTrapOrWaterPermitted_isWakable(MassCreater.getMass(goal.getPoint(), d), goal);
    }

    private static boolean isTrapOrWaterPermitted_isWakable(Mass start, Mass goal) {
        if (!start.WALKABLE) {
            return false;
        }
        DIRECTION d = DIRECTION.getDirection(start.getPoint(), goal.getPoint());
        if (DIRECTION.isBias(d)) {
            if (MapList.getPermittedValue(start, d.getNeiboringDirection()) == 2) {
                return false;
            }
            if (MapList.getPermittedValue(start, d.getDeNeiboringDirection()) == 2) {
                return false;
            }
        }
        return true;
    }

    public static void judgement() {
        Player.me.saisen = null;
        Player.me.shop = null;
        FrameShaker.doneStrongly();
        String[] msg = new String[]{"\u3042\u306a\u305f\u306e\u884c\u70ba\u306f\u771f\u3063\u9ed2\u3067\u3059\uff01", "\u56e0\u679c\u5fdc\u5831\u5929\u7f70\u89bf\u9762\uff01", "\u884c\u304d\u307e\u3059\u3088\u5c0f\u753a\uff01", "\u3042\uff5e\u3089\u3089\u3001\u9762\u5012\u306a\u3053\u3068\u3059\u308b\u306d\u3047", "\u3084\u308c\u3084\u308c\u3001\u304a\u4ed5\u4e8b\u306e\u6642\u9593\u3060\u306d\u3047"};
        Message.setConcatFlag(false);
        Message.set(msg[(int)Math.floor(new R().nextDouble() * (double)msg.length)]);
        SE.SYSTEM_MONSTER_HOUSE.play();
        Player.me.setAnimation(new Base_Anime(Player.me){

            @Override
            protected boolean draw(Graphics2D g) {
                Player.me.startDamaging();
                return this.isFrameLessThan(30);
            }
        });
        BGM.dorobo.play(100L);
        MapList.setFlagSheef(true);
        EnemyTable.setFlagSheefFirstEnemy();
    }

    public static void load(MapList ml) {
        MapList.clear();
        ME = ml;
    }

    public static void nextFloor() {
        if (next_floor_asc) {
            MapList.ascFloor();
        } else {
            MapList.desFloor();
            MapList.setNextFloor(false);
        }
    }

    public static void performMonsterHosue() {
        boolean flag_nobody = true;
        for (Base_Enemy em : MapList.getListEnemy()) {
            if (!MassCreater.isPlayerInTheSameRoom(em.getMassPoint())) continue;
            flag_nobody = false;
            break;
        }
        Player.me.setCondition(CONDITION.\u900f\u8996, 0);
        SE.SYSTEM_MONSTER_HOUSE.play();
        if (flag_nobody) {
            int item_count = 0;
            for (Base_Artifact a : MapList.getListArtifact()) {
                if (!(a instanceof Base_Item) || !MassCreater.isPlayerInTheSameRoom(a.getMassPoint())) continue;
                ++item_count;
            }
            if (item_count > 5) {
                FrameShaker.doneNormaly();
                Message.set("\u30a2\u30a4\u30c6\u30e0\u30cf\u30a6\u30b9\u3060\uff01");
            } else {
                FrameShaker.doneSoftly();
                Message.set("\u30e2\u30f3\u30b9\u30bf\u30fc\u30cf\u30a6\u30b9\u3060\u3063\u305f\uff01");
            }
        } else {
            MapList.awaken();
            FrameShaker.doneStrongly();
            MassCreater.flag_neglect_bgm = true;
            if (PresentField.get().SMH == null) {
                Message.set("\u30e2\u30f3\u30b9\u30bf\u30fc\u30cf\u30a6\u30b9\u3060\uff01\uff01");
                BGM.TakeAChance.play(100L);
            } else {
                Message.set(PresentField.get().SMH.name().concat("\u3060\uff01\uff01"));
                BGM.black.play(100L);
            }
            Player.me.setAnimation(new Base_Anime(Player.me){

                @Override
                protected boolean draw(Graphics2D g) {
                    Player.me.startDamaging();
                    return this.isFrameLessThan(30);
                }
            });
        }
    }

    private static Base_Enemy randomEnemy(Point p) {
        Base_Enemy em = EnemyTable.getRandomEnemy(0);
        if (em == null) {
            em = new \u3086\u3063\u304f\u308a\u970a\u5922(p, 1);
        }
        em.setMassPoint(p);
        return em;
    }

    public static synchronized void removeArtifact(Base_Artifact af) {
        list_artifact.remove(af);
    }

    public static synchronized void removeEnemy(Base_Enemy em) {
        list_enemy.remove(em);
    }

    public static void resetHutoChan() {
        huto_waters = null;
    }

    public static void setFlagSheef(boolean b) {
        flag_sheef_start = b;
    }

    public static void setFloor(int f) {
        MapList.ME.floor = f;
    }

    public static void setNextFloor(boolean asc) {
        next_floor_asc = asc;
    }

    public static void setTrapOnMap(Point p, Base_Artifact a) {
        if (MapList.getArtifact(p) == null) {
            MapList.addArtifact(a);
        }
    }

    public static void summonEnemy(Point p, int value, Base_Enemy em, CONDITION ... C) {
        if (em != null) {
            CONDITION[] cONDITIONArray = C;
            int n = C.length;
            int n2 = 0;
            while (n2 < n) {
                CONDITION c = cONDITIONArray[n2];
                em.setCondition(c, 0);
                ++n2;
            }
        }
        ArrayList<Point> list_blank = new ArrayList<Point>();
        Point point = new Point();
        int count = 0;
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                point.x = p.x + i;
                point.y = p.y + j;
                if (MassCreater.getMass((Point)point).WALKABLE && MapList.getCreature(point) == null && Player.me.getMassPoint() != point) {
                    list_blank.add(new Point(point.x, point.y));
                }
                ++j;
            }
            ++i;
        }
        R ran = new R();
        if (list_blank.size() <= value) {
            for (Point blank_point : list_blank) {
                if (value <= count) {
                    return;
                }
                if (em == null) {
                    Base_Enemy e = MapList.randomEnemy(blank_point);
                    CONDITION[] cONDITIONArray = C;
                    int n = C.length;
                    int n3 = 0;
                    while (n3 < n) {
                        CONDITION c = cONDITIONArray[n3];
                        e.setCondition(c, 0);
                        ++n3;
                    }
                    e.enemy_actioned = true;
                    e.flag_3rd_move = true;
                    e.flag_2nd_move = true;
                    MapList.addEnemy(e);
                    MainMap.addEffect(new DoronEffect(e.getMassPoint(), new Task(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void work() {
                        }
                    }));
                } else {
                    em.setMassPoint(blank_point);
                    MapList.addEnemy(em);
                    MainMap.addEffect(new DoronEffect(em.getMassPoint(), new Task(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void work() {
                        }
                    }));
                }
                ++count;
            }
        } else {
            while (true) {
                if (value <= count) {
                    return;
                }
                int selection = ((Random)ran).nextInt(list_blank.size());
                if (MapList.getEnemy((Point)list_blank.get(selection)) != null) continue;
                if (em == null) {
                    CONDITION c;
                    Base_Enemy e = MapList.randomEnemy((Point)list_blank.get(selection));
                    CONDITION[] cONDITIONArray = C;
                    int n = C.length;
                    int n4 = 0;
                    while (n4 < n) {
                        c = cONDITIONArray[n4];
                        e.setCondition(c, 0);
                        ++n4;
                    }
                    e.enemy_actioned = true;
                    cONDITIONArray = C;
                    n = C.length;
                    n4 = 0;
                    while (n4 < n) {
                        c = cONDITIONArray[n4];
                        e.setCondition(c, 0);
                        ++n4;
                    }
                    MapList.addEnemy(e);
                    MainMap.addEffect(new DoronEffect(e.getMassPoint(), new Task(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void work() {
                        }
                    }));
                } else {
                    em.setMassPoint((Point)list_blank.get(selection));
                    MapList.addEnemy(em);
                    MainMap.addEffect(new DoronEffect(em.getMassPoint(), new Task(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void work() {
                        }
                    }));
                }
                ++count;
            }
        }
    }

    public static void water(Base_Artifact af) {
        if (af != null && !af.getListComposition().contains((Object)ENCHANT_SIMBOL.\u91d1)) {
            if (af instanceof SpellCard) {
                af.setForgeValue(-1);
            } else if (af instanceof Food && !(af instanceof \u8150\u3063\u305f\u304a\u306b\u304e\u308a)) {
                \u8150\u3063\u305f\u304a\u306b\u304e\u308a a = new \u8150\u3063\u305f\u304a\u306b\u304e\u308a(af.getMassPoint());
                a.flag_pick_checked = ((Food)af).flag_pick_checked;
                MapList.removeArtifact(af);
                MapList.addArtifact(a);
            } else if (af instanceof Base_Trap) {
                MapList.removeArtifact(af);
            }
        }
    }

    private MapList() {
    }

    public MapList(MapList mp) {
        this.floor = mp.floor;
    }
}

