/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.config.table;

import connection.sv_cl.SocketHolder;
import dangeon.model.config.Config;
import dangeon.model.config.table.ItemDetail;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.map.field.random.Base_Map_Random;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.arrow.Arrow;
import dangeon.model.object.artifact.item.food.Food;
import dangeon.model.object.artifact.item.food.\u5947\u8de1\u306e\u304a\u306b\u304e\u308a;
import dangeon.model.object.artifact.item.food.\u8150\u3063\u305f\u304a\u306b\u304e\u308a;
import dangeon.model.object.artifact.item.scrool.\u5207\u308c\u7aef;
import dangeon.model.object.creature.npc.second.Takarabako;
import dangeon.model.object.creature.player.class_job.bonus.bonus_switch.BonusConductor;
import dangeon.util.Flag;
import dangeon.util.R;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.HashMap;
import main.util.FileReadSupporter;
import main.util.Show;

public class ItemTable {
    private static HashMap<Class<?>, Integer> map = new HashMap();

    public static Class<?> createClazz(String package_package_classname) {
        try {
            return Class.forName("dangeon.model.object.artifact.".concat(package_package_classname));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Base_Artifact createObject(Point p, Class<?> c) {
        try {
            Constructor<?> con;
            Object obj;
            if (c == null) {
                return new \u8150\u3063\u305f\u304a\u306b\u304e\u308a(p);
            }
            if (Food.class.isAssignableFrom(c) && BonusConductor.\u5b88\u77e2\u795e()) {
                return new \u5947\u8de1\u306e\u304a\u306b\u304e\u308a(p);
            }
            if (Arrow.class.isAssignableFrom(c) && (obj = (con = c.getConstructor(Point.class, Boolean.TYPE)).newInstance(p, true)) instanceof Base_Artifact) {
                return (Base_Artifact)obj;
            }
            con = c.getConstructor(Point.class);
            obj = con.newInstance(p);
            if (obj instanceof Base_Artifact) {
                return (Base_Artifact)obj;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void createTresureBox() {
        MapList.addEnemy(new Takarabako(MassCreater.getTrapIP()));
    }

    private static void detailParcent() {
        ItemDetail id;
        int c1 = 0;
        double count = 0.0;
        ItemDetail[] itemDetailArray = ItemDetail.values();
        int n = itemDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            id = itemDetailArray[n2];
            c1 += id.parcent_value;
            ++n2;
        }
        itemDetailArray = ItemDetail.values();
        n = itemDetailArray.length;
        n2 = 0;
        while (n2 < n) {
            id = itemDetailArray[n2];
            for (Class<?> c : id.category_list) {
                double d = (double)id.rank_map.get(c).PARCENT / (double)id.parcent_value * ((double)id.category_parcent / 100.0) * 100.0;
                count += d;
                BigDecimal bigDecimal = new BigDecimal(d);
            }
            count = 0.0;
            ++n2;
        }
    }

    private static void getMap() {
        int count = 0;
        int c1 = 0;
        ItemDetail[] itemDetailArray = ItemDetail.values();
        int n = itemDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDetail id = itemDetailArray[n2];
            for (Class<?> c : id.category_list) {
                if (map.get(c) == null) continue;
                count += map.get(c).intValue();
            }
            c1 += count;
            count = 0;
            ++n2;
        }
        ItemTable.detailParcent();
    }

    public static int getMerchantValue(Base_Item base_Item) {
        switch (ItemDetail.getRank(base_Item)) {
            case S: {
                return 60;
            }
            case A: {
                return 25;
            }
            case B: {
                return 4;
            }
            case C: {
                return 2;
            }
            case D: {
                return 1;
            }
        }
        return 10;
    }

    public static int getRank(Base_Artifact base_Item) {
        switch (ItemDetail.getRank(base_Item)) {
            case S: {
                return 5;
            }
            case A: {
                return 4;
            }
            case B: {
                return 3;
            }
            case C: {
                return 2;
            }
            case D: {
                return 1;
            }
        }
        return 1;
    }

    public static String getRank_String(Base_Artifact a) {
        ItemDetail.RANK r = ItemDetail.getRank(a);
        switch (r) {
            case S: {
                return "\uff33";
            }
            case A: {
                return "\uff21";
            }
            case B: {
                return "\uff22";
            }
            case C: {
                return "\uff23";
            }
            case D: {
                return "\uff24";
            }
        }
        return "\uff0a";
    }

    public static Base_Artifact itemReturn(Point p, boolean only_rare___or___perfectedlly_random) {
        return ItemTable.createObject(p, ItemDetail.getItem(only_rare___or___perfectedlly_random));
    }

    public static Base_Artifact itemReturn(Point p, ItemDetail id) {
        return ItemTable.selectArtifact(p, id);
    }

    private static void itemTableCreate() {
        try {
            InputStreamReader read = FileReadSupporter.readUTF8("res/table/\u30c6\u30b9\u30c8\u30d5\u30a3\u30fc\u30eb\u30c9".concat(".csv"));
            ItemTable.itemTableCreate(new BufferedReader(read));
        }
        catch (FileNotFoundException e) {
            Show.showCriticalErrorMessageDialog("ItemTable\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093@FileReader-ItemTable");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void itemTableCreate(BufferedReader bf) {
        String str = "";
        try {
            int percent = 0;
            String category = null;
            boolean roop = true;
            while ((str = bf.readLine()) != null) {
                if ((str = str.trim()).startsWith("TRAP")) break;
                if (roop) {
                    if (!str.startsWith("ITEM")) continue;
                    roop = false;
                    continue;
                }
                if (str.isEmpty()) break;
                if (str.startsWith("category")) {
                    String[] s = str.split("\\.");
                    category = s[1].split("\t")[0];
                    String weight = str.split("\t")[1];
                    percent = weight.isEmpty() ? 0 : Integer.valueOf(weight);
                    ItemDetail.setPercent(category, percent);
                    continue;
                }
                String[] detail = str.split("\t");
                String item_name = detail[0];
                String rank = detail[1];
                Class<?> c = ItemTable.returnClass(item_name, category);
                ItemDetail.setList(category, rank, c);
            }
            bf.close();
            ItemDetail.start();
        }
        catch (IOException e) {
            Show.showErrorMessageDialog(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("arrayIndex[" + str + "]");
        }
    }

    private static void itemTableCreate(String dun_name) {
        try {
            InputStreamReader read = FileReadSupporter.readUTF8("res/table/".concat(dun_name).concat(".csv"));
            ItemTable.itemTableCreate(new BufferedReader(read));
        }
        catch (FileNotFoundException e) {
            Show.showCriticalErrorMessageDialog("ItemTable\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093@FileReader-ItemTable");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static StringBuffer randomTableCreate() {
        StringBuffer sb = new StringBuffer();
        try {
            InputStreamReader read = FileReadSupporter.readUTF8("res/table/table.csv");
            sb = ItemTable.randomTableCreate(new BufferedReader(read));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return sb;
    }

    private static StringBuffer randomTableCreate(BufferedReader br) {
        boolean _flag = false;
        StringBuffer sb = new StringBuffer("ITEM\n");
        try {
            String str;
            while ((str = br.readLine()) != null) {
                if ((str = str.trim()).isEmpty()) continue;
                if (str.startsWith("ENEMY") || str.startsWith("TRAP")) {
                    _flag = false;
                    continue;
                }
                if (str.startsWith("ITEM")) {
                    _flag = true;
                    continue;
                }
                if (!_flag) continue;
                if (str.startsWith("category")) {
                    sb.append(str);
                    sb.append("\n");
                    continue;
                }
                String[] cut = str.split("\t");
                sb.append(cut[0].trim());
                sb.append("\t");
                sb.append((Object)ItemDetail.RANK.values()[R.ran(ItemDetail.RANK.values().length)]);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb;
    }

    public static Base_Artifact returnBaseArtifactSetPoint(String package_package_classname, Point p) {
        try {
            Class<?> clazz = Class.forName("dangeon.model.object.artifact.".concat(package_package_classname));
            return ItemTable.createObject(p, clazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Class<?> returnClass(String str, String category) {
        category = category.trim();
        try {
            Class<?> clazz = Class.forName("dangeon.model.object.artifact.item.".concat(category.concat(".")).concat(str));
            return clazz;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Base_Artifact selectArtifact(Point p, ItemDetail id) {
        Base_Artifact a;
        if (id == null && BonusConductor.\u30d5\u30e9\u30ef\u30fc\u30de\u30b9\u30bf\u30fc() && new R().is(25)) {
            id = ItemDetail.GRASS;
        }
        if (p == null) {
            p = MassCreater.getItemIP();
        }
        if ((a = ItemTable.createObject(p, ItemDetail.getItem(id))) != null) {
            return a.defaultCurse();
        }
        if (id == null) {
            new Exception("ItemTable\u304c\u5b58\u5728\u3057\u307e\u305b\u3093@ItemTable.selectArtifact").printStackTrace();
            return new \u8150\u3063\u305f\u304a\u306b\u304e\u308a(p);
        }
        Show.showErrorMessageDialog((Object)((Object)id) + "\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\uff08\u4ee3\u308f\u308a\u306b\u8150\u3063\u305f\u304a\u306b\u304e\u308a\u3092\u751f\u6210\u3057\u307e\u3059\uff09");
        return new \u8150\u3063\u305f\u304a\u306b\u304e\u308a(p);
    }

    public static boolean setItemInMonsterHouse(Point p) {
        if (p.x == Mass.nullpo.X) {
            return false;
        }
        MapList.addArtifact(ItemTable.selectArtifact(p, null));
        return true;
    }

    private static void setMap(Class<?> a) {
        block1: {
            int i = 0;
            do {
                ++i;
                if (map.get(a) != null) continue;
                map.put(a, i);
                break block1;
            } while (map.get(a) >= i);
            map.put(a, i);
        }
    }

    public static void setOnMapInNormalFirst() {
        int try_numbers = Flag.isFlagItemPlus() ? 2 : 1;
        int count = 0;
        while (count < try_numbers) {
            int hosei;
            Base_Map_Random random_map;
            int ran = PresentField.get().defaultItemNumber();
            if (SocketHolder.isConnected() && (random_map = PresentField.get().getRandomMap()) != null) {
                ran -= random_map.dangerLv(MapList.getFloor()) - (Config.getFate() - 1);
            }
            if (ran > 0 && (hosei = 3 - MapList.getFloor()) > 0) {
                ran += hosei;
            }
            int i = 0;
            while (i < ran) {
                Base_Artifact a = ItemTable.selectArtifact(null, null);
                MapList.addArtifact(a);
                ++i;
            }
            double parcent = 70.0;
            double device = 0.3;
            while (new R().is((int)parcent)) {
                \u5207\u308c\u7aef a = new \u5207\u308c\u7aef(MassCreater.getItemIP());
                MapList.addArtifact(a);
                parcent *= device;
            }
            ++count;
        }
        int r = (PresentField.get().getShopParcent() + PresentField.get().getSaisenParcent()) * 2 / 3;
        if (new R().is(r)) {
            ItemTable.createTresureBox();
        }
    }

    private static void tableReset() {
        ItemDetail.resetDate();
    }

    public static void test() {
        int i = 0;
        while (i < 1000) {
            ItemTable.setMap(ItemDetail.getItem(null));
            ++i;
        }
        ItemTable.getMap();
    }

    public static void testCreate() {
        ItemTable.tableReset();
        ItemTable.itemTableCreate();
    }

    public static void testCreate(BufferedReader table) {
        ItemTable.tableReset();
        ItemTable.itemTableCreate(table);
    }

    public static void testCreate(String str) {
        ItemTable.tableReset();
        ItemTable.itemTableCreate(str);
    }
}

