/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.otog.main;

import dangeon.latest.scene.action.otog.Fader;
import dangeon.latest.scene.action.otog.object.Bar;
import dangeon.latest.scene.action.otog.object.TargetA;
import dangeon.latest.scene.action.otog.object.TargetA_Long;
import dangeon.latest.scene.action.otog.object.TargetD;
import dangeon.latest.scene.action.otog.value.ValueHolder;
import dangeon.model.config.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import main.constant.FR;
import main.util.DIRECTION;

public class Initializer {
    public int first_beats;
    public int end_mp3_frame;
    public final ValueHolder VH;
    public final int[] random_row = new int[4];
    public final int[] random_dir = new int[8];

    public Initializer(ValueHolder vh) {
        this.VH = vh;
        ArrayList<Integer> list = new ArrayList<Integer>(4);
        ArrayList<Integer> list_dir = new ArrayList<Integer>(4);
        int i = 0;
        while (i < this.random_row.length) {
            list.add(i);
            list_dir.add((i + 1) * 2);
            ++i;
        }
        if (this.VH.flag_random != 0) {
            Collections.shuffle(list);
        }
        if (this.VH.flag_random == 2) {
            Collections.shuffle(list_dir);
        }
        i = 0;
        while (i < this.random_row.length) {
            this.random_row[i] = (Integer)list.get(i) + 1;
            ++i;
        }
        i = 0;
        while (i < this.random_dir.length) {
            this.random_dir[i] = i % 2 == 0 ? i + 1 : (Integer)list_dir.get(i / 2);
            ++i;
        }
    }

    private void add(long mp3Frame, int row, int i, int bpm) {
        if (i == 0) {
            return;
        }
        if (row == 0) {
            this.VH.list.add(new TargetD(DIRECTION.getFromNUM(this.random_dir[i - 1]), this.VH, mp3Frame));
        } else {
            row = this.random_row[row - 1];
            if (Config.isOtogArrowRight()) {
                --row;
            }
            if (i == 1) {
                this.VH.list.add(new TargetA(row, this.VH, mp3Frame));
            } else {
                this.VH.list.add(new TargetA_Long(this.getMp3Frame(i, bpm), row, this.VH, mp3Frame));
            }
        }
    }

    private void addBar(long mp3Frame) {
        this.VH.bars.add(new Bar(this.VH, mp3Frame));
    }

    public long game_start() {
        if (Config.getOtogFPS() == 60) {
            FR.changeSleep(16);
        }
        long sleep = this.vh();
        this.VH.end_mp3_frame = this.end_mp3_frame;
        this.VH.node_sum = this.VH.list.size();
        this.VH.HEAL_MILLI_RATE = 7605L * this.VH.node_sum / (this.VH.node_sum * 10L + 6500L) * 1000L;
        if (this.VH.HEAL_MILLI_RATE < 260000L) {
            this.VH.HEAL_MILLI_RATE = 260000L;
        }
        this.VH.HEAL_MILLI_RATE /= this.VH.node_sum;
        return sleep;
    }

    private long getMilliSecond(int beats, int bpm) {
        if (bpm == 0) {
            return 0L;
        }
        return beats * 60 * 1000 / (bpm * 12);
    }

    private long getMp3Frame(int beats, int bpm) {
        long ms = this.getMilliSecond(beats, bpm);
        return this.VH.bgm.getMP3MilliFrame(ms);
    }

    private long load(File file) {
        BufferedReader br = null;
        int bpm = 0;
        long first_milli_second = 0L;
        long first_mute = this.VH.bgm.getMP3MilliFrame(4000L);
        try {
            FileReader filereader = new FileReader(file);
            br = new BufferedReader(filereader);
            String line = br.readLine();
            long sum = 0L;
            int beats = 0;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, ",", false);
                if (!st.hasMoreTokens()) continue;
                String s_bpm = st.nextToken();
                if (!s_bpm.matches("_")) {
                    sum += this.getMp3Frame(beats, bpm);
                    bpm = Integer.valueOf(s_bpm);
                    if (first_milli_second == 0L) {
                        first_milli_second = this.getMilliSecond(beats, bpm);
                        this.first_beats = beats;
                    }
                    beats = 0;
                    this.addBar(first_mute + sum);
                    continue;
                }
                int row = 0;
                while (st.hasMoreTokens()) {
                    int i = Integer.valueOf(st.nextToken());
                    this.add(first_mute + sum + this.getMp3Frame(beats, bpm), row++, i, bpm);
                }
                ++beats;
            }
            this.end_mp3_frame = (int)((first_mute + (sum += this.getMp3Frame(beats, bpm)) + 500L) / 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "\u30ed\u30fc\u30c9\u306b\u5931\u6557\u307e\u3057\u305f");
            new Fader(this.VH.MAIN_PANEL.PARENT, this.VH.MAIN_PANEL.PARENT.getNextSelectScene());
            return -1L;
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return first_milli_second;
    }

    private long vh() {
        this.VH.list.clear();
        this.VH.bars.clear();
        this.VH.objects.clear();
        return this.load(this.VH.CONTENT.FILE);
    }
}

