/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.message;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Conversation;
import dangeon.latest.scene.action.message.MessageLock;
import dangeon.latest.scene.action.message.MsgBlock;
import dangeon.latest.util.view_window.WindowFrame;
import dangeon.model.config.Config;
import dangeon.model.object.creature.player.Player;
import dangeon.view.constant.NormalFont;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import main.Listener;
import main.res.Image_LargeCharacter;
import main.res.SE;

public class Message {
    public static final Integer X = null;
    public static final Integer Y = 250;
    public static final Integer WINDOW_Y = Y - 10;
    public static final Integer W = 370;
    public static final Integer COLS = 3;
    private static final ArrayList<MsgBlock> message_task = new ArrayList();
    private static ArrayList<Task> task_list = new ArrayList();
    private static Image_LargeCharacter ilc = Image_LargeCharacter.ANY;
    private final int RECORD = 100;
    public static final Message ME = new Message();
    private static final int HOLDING_INTERVAL = 60;
    private static final int WAITING_INTERVAL = 1;
    private final ArrayList<Line> task;
    private final ArrayList<String> record;
    private final WindowFrame WINDOW_FRAME;
    private int holding_time;
    private int waiting_time;
    private int diff;
    private boolean turn_switch;
    private boolean record_switch;
    private ArrayList<Conversation> conv_list = new ArrayList();
    private Color previous_color;
    public static final String HORIZON = "&--";
    public static final int MAX_RECORD = 100;
    private static final ArrayList<String> message_record = new ArrayList(100);
    private boolean flag_concat = true;
    private boolean flag_turn_start = true;

    public static void clearRecord() {
        Message.ME.record.clear();
    }

    static void endTask() {
        MsgBlock mb = message_task.get(0);
        if (mb.isSlept) {
            Player.flag_clear = false;
        }
        Message.setRecord(mb.getMsg().toArray(new String[0]));
        if (!mb.TASK_LIST.isEmpty()) {
            for (Task task : mb.TASK_LIST) {
                task.work();
            }
            mb.TASK_LIST.clear();
        }
        message_task.remove(0);
    }

    public static MsgBlock getNextTask() {
        return message_task.get(1);
    }

    public static String[] getRecord() {
        return message_record.toArray(new String[0]);
    }

    public static String getRecord(int i) {
        return message_record.get(i);
    }

    public static int getRecordSize() {
        return Message.ME.record.size();
    }

    public static MsgBlock getTask() {
        return message_task.get(0);
    }

    public static boolean isDemandToWaitAnySystem() {
        return ME.isDemandToWaitAnySystem_();
    }

    public static boolean isDemandToWaitPushingAnyKey() {
        return ME.isDemandToWaitPushingAnyKey_();
    }

    public static boolean isNextTaskEmpty() {
        return message_task.size() == 1;
    }

    public static boolean isTaskEmpty() {
        return message_task.isEmpty();
    }

    @Deprecated
    public static void releaseLock() {
        ME.releaseLock_(null);
    }

    public static void releaseLock(LinkedHashSet<Listener.ACTION> tasklist_action) {
        ME.releaseLock_(tasklist_action);
    }

    public static void removeILC() {
        ilc = Image_LargeCharacter.ANY;
    }

    public static void set(Object ... strings) {
        String[] arr = new String[strings.length];
        int i = 0;
        while (i < arr.length) {
            arr[i] = strings[i].toString();
            ++i;
        }
        Message.set(arr);
    }

    public static void set(String ... strings) {
        ME.set_non_statiic(strings);
    }

    public static void setConcatFlag(boolean b) {
        Message.ME.flag_concat = b;
    }

    public static void setImageLargeCharacter(Image_LargeCharacter im_lc) {
        ilc = im_lc == null ? Image_LargeCharacter.ANY : im_lc;
    }

    public static void setMessageTask(Task task_work_at_complete_apperance, String ... array) {
        Message.set(array);
        if (task_work_at_complete_apperance != null) {
            message_task.get(message_task.size() - 1).setTask(task_work_at_complete_apperance);
        }
    }

    public static void setMessageTask_AfterSleepDeamandKeyPush(int sleep, String ... array) {
        ArrayList<String> list = new ArrayList<String>(array.length);
        boolean flag = false;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            list.add(str);
            ++n2;
        }
        if (!flag) {
            Message.removeILC();
        }
        if (!list.isEmpty()) {
            message_task.add(new MsgBlock(ilc, list, sleep));
        }
    }

    public static void setRecord(String ... arr) {
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (message_record.size() == 100) {
                message_record.remove(0);
            }
            message_record.add(str);
            ++n2;
        }
        if (message_record.size() == 100) {
            message_record.remove(0);
        }
        message_record.add("\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u25bc");
    }

    public static void setTask_AfterReleaseDemandToPushEnter(Task task) {
        ME.setTask_AfterReleaseDemandToPushEnter_non_static(task);
    }

    public static void setTurnStartFlagOn() {
        Message.ME.flag_turn_start = true;
    }

    public static void end() {
        ME.reset();
    }

    private Message() {
        this.task = new ArrayList();
        this.record = new ArrayList(100);
        this.WINDOW_FRAME = new WindowFrame(X, WINDOW_Y, W, COLS);
        this.reset();
    }

    boolean addConv(Conversation conversation) {
        this.conv_list.add(conversation);
        return this.conv_list.size() == 1;
    }

    private void concat() {
        if (!this.flag_concat || this.task.isEmpty()) {
            boolean bl = this.turn_switch = !this.turn_switch;
            if (this.flag_turn_start && !this.task.isEmpty()) {
                for (Line line : this.task) {
                    line.rapid = true;
                }
            } else {
                this.flag_turn_start = false;
            }
        }
        this.flag_concat = true;
    }

    public void draw(Graphics2D g) {
        if (!this.conv_list.isEmpty()) {
            this.WINDOW_FRAME.drawWindow(g);
            this.drawStringField(g, this.conv_list.get(0));
        } else if (!this.task.isEmpty()) {
            if (this.holding_time < 60) {
                this.WINDOW_FRAME.drawWindow(g);
                this.drawStringField(g);
            } else {
                this.reset();
            }
        }
    }

    private void draw4Strings(Graphics2D g, WindowFrame wf) {
        int h = wf.getContentHeight();
        if (this.diff < h) {
            if (this.previous_color != null) {
                g.setColor(this.previous_color);
            }
            int i = 0;
            while (i < COLS + 1 && i < this.task.size()) {
                wf.drawString(g, this.task.get(i).MSG, i + 1, -this.diff);
                ++i;
            }
            this.previous_color = StringFilter.getColor(g, this.task.get(0).MSG);
            if (this.waiting_time > 0) {
                --this.waiting_time;
            } else {
                this.diff += this.speed();
            }
        } else {
            this.remove();
            if (this.task.size() < 6) {
                this.waiting_time = 2;
                this.diff = 0;
            } else {
                this.diff -= h;
            }
            this.drawString(g, wf);
        }
    }

    private void drawbelow4Strings(Graphics2D g, WindowFrame wf, boolean lock) {
        int max = lock ? this.getIndexOfLockInCOLS() + 1 : this.task.size();
        int i = 0;
        while (i < max) {
            wf.drawString(g, this.task.get(i).MSG, i + 1, 0);
            ++i;
        }
    }

    private boolean drawString(Graphics2D g, WindowFrame wf) {
        if (this.isLockInCOLS()) {
            this.drawbelow4Strings(g, wf, true);
            return true;
        }
        if (this.task.size() <= COLS) {
            boolean b = true;
            for (Line line : this.task) {
                boolean bl = b = line.rapid && b;
            }
            if (b) {
                this.draw4Strings(g, wf);
            } else {
                this.drawbelow4Strings(g, wf, false);
            }
            ++this.holding_time;
        } else {
            this.draw4Strings(g, wf);
        }
        return false;
    }

    private void drawStringField(Graphics2D g) {
        WindowFrame wf = this.WINDOW_FRAME.createDoubleSizeClearCopy();
        if (this.drawString(wf.initGraphics2Scaled(), wf)) {
            this.WINDOW_FRAME.drawArrow(g, false);
        }
        wf.drawWindow(g);
    }

    private void drawStringField(Graphics2D g, Conversation conv) {
        WindowFrame wf = this.WINDOW_FRAME.createDoubleSizeClearCopy();
        int i = 0;
        String[] stringArray = conv.getTEXT();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            wf.drawString(wf.initGraphics2Scaled(), s, ++i, 0);
            ++n2;
        }
        if (!conv.isSelection()) {
            this.WINDOW_FRAME.drawArrow(g, conv.isWriting());
        }
        wf.drawWindow(g);
        conv.drawName(g);
    }

    private int getIndexOfLockInCOLS() {
        int i = 0;
        for (Line line : this.task) {
            if (line.push) {
                return i;
            }
            if (++i != COLS) continue;
            return -1;
        }
        return -1;
    }

    public String[] getRecordToArray() {
        return this.record.toArray(new String[0]);
    }

    private boolean isDemandToWaitAnySystem_() {
        return this.task.size() > 8;
    }

    private boolean isDemandToWaitPushingAnyKey_() {
        if (!this.conv_list.isEmpty()) {
            return true;
        }
        for (Line line : this.task) {
            if (!line.push) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.task.isEmpty() && this.conv_list.isEmpty();
    }

    private boolean isLockInCOLS() {
        return this.getIndexOfLockInCOLS() != -1;
    }

    private void release() {
        if (Message.getTask().isLast()) {
            SE.SYSTEM_ENTER.play();
            Message.getTask().wait_for_pushing_any_key = false;
            Message.endTask();
            if (message_task.isEmpty() || !Message.message_task.get((int)0).wait_for_pushing_any_key) {
                ArrayList<Task> list = new ArrayList<Task>(task_list.size());
                for (Task task : task_list) {
                    list.add(task);
                }
                for (Task task : list) {
                    task.work();
                    task_list.remove(task);
                }
            }
        }
    }

    private void releaseLock_(int index) {
        SE.SYSTEM_ENTER.play();
        Line line = this.task.get(index);
        int i = 0;
        while (i <= index) {
            this.remove();
            ++i;
        }
        if (line.task != null) {
            line.task.second();
        }
    }

    private void releaseLock_(LinkedHashSet<Listener.ACTION> tasklist_action) {
        if (!this.conv_list.isEmpty()) {
            Conversation c = this.conv_list.get(0);
            if (c.isSelection()) {
                c.EVENT.passActionIntoSelectBox(tasklist_action);
                if (c.isSelection()) {
                    return;
                }
                c.EVENT = null;
            }
            if (c.EVENT != null) {
                c.EVENT.workAfterPush();
                if (c.isSelection()) {
                    return;
                }
            }
            this.conv_list.remove(0);
            if (this.conv_list.isEmpty()) {
                Image_LargeCharacter.slideOUT_Conv_end();
            } else {
                this.conv_list.get(0).slideIN();
            }
        } else {
            this.releaseLock__();
        }
        SE.SYSTEM_ENTER.play();
    }

    private void releaseLock__() {
        boolean flag = false;
        int i = 0;
        for (Line line : this.task) {
            if (line.push) {
                flag = true;
                break;
            }
            if (++i != COLS) continue;
            return;
        }
        if (flag) {
            this.releaseLock_(i);
        }
    }

    private void remove() {
        Line line = this.task.remove(0);
        if (line.group != this.record_switch) {
            this.record.add(HORIZON);
            boolean bl = this.record_switch = !this.record_switch;
        }
        if (this.record.size() >= 100) {
            this.record.remove(0);
        }
        this.record.add(this.record.lastIndexOf(HORIZON), line.MSG);
    }

    private void reset() {
        while (!this.task.isEmpty()) {
            this.remove();
        }
        this.holding_time = 0;
        this.diff = 0;
        this.previous_color = null;
    }

    @Deprecated
    void set(MessageLock t) {
        this.set_non_statiic(t.FIRST_MSG);
        Line line = this.task.get(this.task.size() - 1);
        this.setPushTrue(line);
        line.task = t;
        for (Line l : this.task) {
            l.rapid = true;
        }
    }

    private void set_non_statiic(String[] strings) {
        this.concat();
        boolean push = false;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.endsWith("@")) {
                s = s.replaceAll("@", "");
                push = true;
            }
            sb.append(s);
            ++n2;
        }
        Color prev_color = null;
        for (String s : StringFilter.getBreakSpacingStrings(NormalFont.NORMALFONT, sb.toString(), W)) {
            if (this.task.isEmpty() && push) {
                SE.SYSTEM_ENTER.play();
            }
            this.task.add(new Line(prev_color != null ? prev_color.toString().concat(s) : s));
            prev_color = StringFilter.getColor(null, s);
        }
        prev_color = null;
        if (push) {
            this.setPushTrue(this.task.get(this.task.size() - 1));
            for (Line line : this.task) {
                line.rapid = true;
            }
        }
        this.holding_time = 0;
    }

    @Deprecated
    private void set_non_statiic_OLD(String[] strings) {
        this.concat();
        StringBuilder sb = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s);
            ++n2;
        }
        for (String s : StringFilter.getBreakSpacingStrings(NormalFont.NORMALFONT, sb.toString(), W)) {
            this.task.add(new Line(s));
        }
        this.holding_time = 0;
    }

    public void setConcatFlag() {
        for (Line line : this.task) {
            line.rapid = true;
        }
    }

    public void setMessage(String ... array) {
        if (this.flag_concat && !Message.isTaskEmpty()) {
            String[] stringArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (str.endsWith("@")) {
                    message_task.get(message_task.size() - 1).setFlagRapid(true);
                    this.flag_concat = false;
                    Message.set(array);
                    return;
                }
                ++n2;
            }
            message_task.get(message_task.size() - 1).concat(array);
        } else {
            if (this.flag_turn_start && !Message.isTaskEmpty()) {
                message_task.get(message_task.size() - 1).setFlagRapid(true);
            } else {
                this.flag_turn_start = false;
            }
            ArrayList<String> list = new ArrayList<String>(array.length);
            boolean flag = false;
            String[] stringArray = array;
            int n = array.length;
            int n3 = 0;
            while (n3 < n) {
                String str = stringArray[n3];
                if (str.endsWith("@")) {
                    flag = true;
                    list.add(str.substring(0, str.length() - 1));
                    message_task.add(new MsgBlock(ilc, list));
                    Message.message_task.get((int)(Message.message_task.size() - 1)).wait_for_pushing_any_key = true;
                    list.clear();
                } else {
                    list.add(str);
                }
                ++n3;
            }
            if (!flag) {
                Message.removeILC();
            }
            if (!list.isEmpty()) {
                message_task.add(new MsgBlock(ilc, list));
            }
        }
        this.flag_concat = true;
        if (Message.message_task.get((int)(Message.message_task.size() - 1)).wait_for_pushing_any_key) {
            this.flag_concat = false;
        }
    }

    private void setPushTrue(Line line) {
        line.push = true;
    }

    public void setTask_AfterReleaseDemandToPushEnter_non_static(final Task _task) {
        Line line = this.task.get(this.task.size() - 1);
        this.setPushTrue(line);
        line.task = new MessageLock(){

            @Override
            public void second() {
                _task.work();
            }
        };
        for (Line l : this.task) {
            l.rapid = true;
        }
    }

    private int speed() {
        double device;
        int i = this.task.size() - COLS;
        if (i < 1) {
            i = 1;
        }
        switch (i) {
            case 1: 
            case 2: 
            case 3: {
                if (!Config.isHighSpeedMessage()) {
                    device = 6.0;
                    break;
                }
            }
            case 4: 
            case 5: 
            case 6: {
                device = 3.0;
                break;
            }
            case 7: 
            case 8: {
                device = 2.0;
                break;
            }
            default: {
                device = 1.5;
            }
        }
        return (int)((double)this.WINDOW_FRAME.getContentHeight() / device);
    }

    private class Line {
        private final String MSG;
        private boolean rapid;
        private boolean push;
        private MessageLock task;
        private final boolean group;

        public Line(String str) {
            this.MSG = str;
            this.group = Message.this.turn_switch;
        }
    }
}

