/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.menu.first.config.keys;

import dangeon.latest.scene.Base_View;
import dangeon.latest.scene.action.menu.Base_Scene_Menu;
import dangeon.latest.scene.action.menu.Base_Scene_Menu_View;
import dangeon.latest.scene.action.menu.first.config.keys.KeyConfig;
import dangeon.latest.scene.action.message.Message;
import dangeon.latest.util.view_window.MenuWindow;
import dangeon.latest.util.view_window.MenuWindow_SelfAdjusting;
import dangeon.model.config.Config;
import dangeon.view.constant.NormalFont;
import dangeon.view.util.StringFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import main.Listener;
import main.pad.JInputWrapper;
import main.res.Image_Window_Frame;
import main.util.DIRECTION;

public class KeyConfig_View
extends Base_Scene_Menu_View {
    public KeyConfig_View(Base_View bv) {
        super(6, 36, Image_Window_Frame.LINE, bv);
    }

    @Override
    protected MenuWindow createMenuWindow() {
        return new MenuWindow_SelfAdjusting(this, (int)Message.W, NormalFont.NORMALFONT.deriveFont(11.0f)){

            private void drawKeyBord(Graphics2D g, int x, int y, String s) {
                StringFilter.drawString(g, s, x += this.W / 8, y);
            }

            private void drawPad(Graphics2D g, int x, int y, String s) {
                StringFilter.drawString(g, s, x += this.W / 8 + 63, y);
            }

            @Override
            protected void drawString(Graphics2D g, int x, int y) {
                int _y = this.getY(g, y, 0) + 3;
                int i = 0;
                while (i < 3) {
                    int _x = this.getX(x, i);
                    g.setColor(StringFilter.NUMBERS);
                    this.drawTitle(g, _x, _y, "NAME");
                    g.setColor(Color.ORANGE);
                    this.drawKeyBord(g, _x, _y, "Key");
                    if (i == 3) break;
                    this.drawPad(g, _x, _y, "Pad");
                    ++i;
                }
                super.drawString(g, x, y);
            }

            @Override
            protected void drawStringFilter(Graphics2D g, int i, int x, int y) {
                Base_Scene_Menu.MenuContent c = this.SCENE.getContent(i);
                if (c.OBJECT instanceof Listener.ACTION) {
                    Listener.ACTION a = (Listener.ACTION)((Object)c.OBJECT);
                    x = this.getX(x, i);
                    y = this.getY(g, y, i);
                    g.setColor(StringFilter.NUMBERS);
                    StringBuilder sb = new StringBuilder();
                    boolean flag = false;
                    if (a == Listener.ACTION.ENTER) {
                        sb.append(Color.MAGENTA);
                        sb.append("Ent ");
                        sb.append(StringFilter.NUMBERS);
                    } else if (a == Listener.ACTION.MENU) {
                        sb.append(Color.MAGENTA);
                        sb.append("Esc ");
                        sb.append(StringFilter.NUMBERS);
                    }
                    for (int keys : Listener.getKey().keySet()) {
                        if (a != Listener.getKey().get(keys)) continue;
                        flag = true;
                        String text = KeyEvent.getKeyText(keys);
                        if (keys == 10 || keys == 27) continue;
                        if (text.length() > 2) {
                            text = text.substring(0, 2);
                        }
                        sb.append(text);
                        sb.append(" ");
                    }
                    this.drawKeyBord(g, x, y, sb.toString());
                    if (!flag && a.IS_MAIN) {
                        g.setColor(Color.RED);
                    } else {
                        g.setColor(Color.WHITE);
                    }
                    this.drawTitle(g, x, y, a.name());
                    sb = new StringBuilder();
                    int j = 0;
                    while (j < JInputWrapper.buttonID.length) {
                        int pad = Config.getPadKey(j);
                        if (pad == a.KEY_NUM) {
                            sb.append(j);
                            sb.append(" ");
                        }
                        ++j;
                    }
                    this.drawPad(g, x, y, sb.toString());
                } else if (c.OBJECT instanceof DIRECTION) {
                    super.drawStringFilter(g, i, x, y);
                    DIRECTION d = (DIRECTION)((Object)c.OBJECT);
                    x = this.getX(x, i);
                    y = this.getY(g, y, i);
                    g.setColor(StringFilter.NUMBERS);
                    StringBuilder sb = new StringBuilder();
                    for (int keys : Listener.getAllow_map().keySet()) {
                        if (keys == 40 || keys == 38 || keys == 39 || keys == 37 || d != Listener.getAllow_map().get(keys)) continue;
                        String text = KeyEvent.getKeyText(keys);
                        if (text.length() > 2) {
                            text = text.substring(0, 2);
                        }
                        sb.append(text);
                        sb.append(" ");
                    }
                    this.drawKeyBord(g, x, y, sb.toString());
                } else {
                    super.drawStringFilter(g, i, x, y);
                }
            }

            private void drawTitle(Graphics2D g, int x, int y, String s) {
                StringFilter.drawString(g, s, x, y);
            }

            @Override
            public void drawWindow(Graphics2D g, boolean current) {
                int y = this.getViewY() + 40;
                int h = 130;
                int y2 = y + h;
                int i = 0;
                while (i < 2) {
                    int x2 = this.getX(0, 1 + i);
                    g.setPaint(new GradientPaint(x2, y, Color.LIGHT_GRAY, x2, (y + y2) / 2, Color.WHITE, true));
                    g.setStroke(new BasicStroke(3.0f));
                    g.drawLine(x2, y, x2, y2);
                    g.setStroke(new BasicStroke());
                    g.setColor(Color.BLACK);
                    g.drawRect(x2 - 2, y - 2, 4, h + 4);
                    ++i;
                }
                super.drawWindow(g, current);
            }

            @Override
            protected int getW_Inside() {
                this.CONTENTS_WIDTH = new int[this.SCENE.ROW.intValue()];
                int i = 0;
                while (i < this.CONTENTS_WIDTH.length) {
                    this.CONTENTS_WIDTH[i] = this.W / this.CONTENTS_WIDTH.length;
                    ++i;
                }
                return this.W;
            }

            @Override
            protected int getX(int x, int index) {
                int row = index % this.SCENE.ROW;
                int _x = x + this.INSETS.left + 5 + row * 140;
                return _x + this.left_padding;
            }
        };
    }

    @Override
    public void draw(Graphics2D g, boolean current) {
        this.drawBlack(g);
        this.drawBlack(g);
        if (current) {
            ((KeyConfig)this.PARENT_SCENE).SUB_WINDOW.drawWindow(g);
        }
        super.draw(g, current);
    }
}

