/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.menu.first.adventure.wiki_item;

import dangeon.latest.scene.Base_Scene;
import dangeon.latest.scene.Base_View;
import dangeon.latest.scene.action.itemlist.Item_List;
import dangeon.latest.scene.action.menu.Base_Scene_Menu;
import dangeon.latest.scene.action.menu.first.adventure.wiki_item.ItemWiki_AllItem;
import dangeon.latest.scene.action.menu.first.adventure.wiki_item.ItemWiki_Command;
import dangeon.latest.system.KeyHolder;
import dangeon.model.config.Config;
import dangeon.model.config.table.ItemTable;
import dangeon.model.object.artifact.Base_Artifact;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public class ItemWiki
extends Item_List {
    public boolean flag_selected;
    public final Base_View BACK;
    public final int INDEX;

    private static Base_Artifact getFrom(ArrayList<Base_Artifact> LIST, Class<?> clazz) {
        for (Base_Artifact a : LIST) {
            if (!a.getClass().equals(clazz)) continue;
            return a;
        }
        return null;
    }

    private static ArrayList<Base_Artifact> initList(int i) {
        String category;
        ArrayList<Base_Artifact> LIST = new ArrayList<Base_Artifact>();
        String data = Config.getItemData(i);
        switch (i) {
            case 0: {
                category = "spellcard";
                break;
            }
            case 1: {
                category = "grass";
                break;
            }
            case 2: {
                category = "ring";
                break;
            }
            case 3: {
                category = "scrool";
                break;
            }
            case 4: {
                category = "staff";
                break;
            }
            case 5: {
                category = "food";
                break;
            }
            case 6: {
                category = "arrow";
                break;
            }
            case 7: {
                category = "pot";
                break;
            }
            default: {
                category = "";
            }
        }
        Point p = new Point();
        category = "item.".concat(category).concat(".");
        for (String s : new ItemWiki_AllItem().get(i)) {
            if (s.isEmpty()) continue;
            Base_Artifact a = ItemTable.returnBaseArtifactSetPoint(category.concat(s), p);
            a.setSampleItem(true);
            LIST.add(a);
        }
        if (data.isEmpty()) {
            return LIST;
        }
        String[] stringArray = data.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s;
            s = stringArray[n2];
            if (!s.isEmpty()) {
                Base_Artifact a = ItemWiki.getFrom(LIST, ItemTable.createClazz(category.concat(s)));
                if (a != null) {
                    a.setSampleItem(false);
                } else {
                    a = ItemTable.returnBaseArtifactSetPoint(category.concat(s), p);
                    if (a != null) {
                        a.setSampleItem(false);
                        a.setFreezeCount(99);
                        LIST.add(a);
                    }
                }
            }
            ++n2;
        }
        Collections.sort(LIST, new Comparator<Base_Artifact>(){

            @Override
            public int compare(Base_Artifact o1, Base_Artifact o2) {
                return o1.getTrueName().compareTo(o2.getTrueName());
            }
        });
        return LIST;
    }

    public ItemWiki(KeyHolder kh, Base_View bv) {
        this(kh, bv, 0);
    }

    public ItemWiki(KeyHolder kh, Base_View bv, int i) {
        super("", null, ItemWiki.initList(i));
        this.BACK = bv;
        this.INDEX = i;
    }

    @Override
    protected void action_enter(int index) {
        this.action_cancel();
    }

    @Override
    public Base_Scene getPreviousScene() {
        return new ItemWiki_Command(this);
    }

    @Override
    public String getTop() {
        StringBuilder sb = new StringBuilder();
        int max = this.LIST.size();
        int count = 0;
        for (Base_Artifact a : this.LIST) {
            if (a.isCold()) {
                --max;
            }
            if (a.flag_unknown || a.isCold()) continue;
            ++count;
        }
        this.percent(sb, count, max);
        this.setPages(sb);
        return sb.toString();
    }

    @Override
    protected void initializeContents(ArrayList<Base_Scene_Menu.MenuContent> list) {
        super.initializeContents(list);
    }

    private void percent(StringBuilder sb, int now, int max) {
        int perc = max == 0 ? 0 : now * 100 / max;
        if (perc < 10) {
            sb.append(Color.PINK);
        } else if (perc < 40) {
            sb.append(Color.ORANGE);
        } else if (perc < 70) {
            sb.append(Color.GREEN);
        } else if (perc < 80) {
            sb.append(Color.BLUE);
        } else if (perc < 90) {
            sb.append(Color.CYAN);
        } else if (perc < 100) {
            sb.append(Color.YELLOW);
        } else {
            sb.append(Color.RED);
        }
        sb.append("\u3010");
        if (perc < 100) {
            sb.append("\u3000");
        }
        if (perc < 10) {
            sb.append("\u3000");
        }
        sb.append(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(perc));
        sb.append("\uff05\u3011");
        sb.append(Color.WHITE);
    }
}

