/*
 * Decompiled with CFR 0.152.
 */
package dangeon.controller.listener.menu;

import dangeon.controller.DangeonScene;
import dangeon.controller.TaskOnMapObject;
import dangeon.controller.task.Task;
import dangeon.model.config.Config;
import dangeon.model.map.MassCreater;
import dangeon.model.map.field.random.Base_Map_Random;
import dangeon.model.map.field.town.map.FairyPlace;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.save.ResultSaveLoad;
import dangeon.model.object.creature.player.save.SaveLoad;
import dangeon.view.detail.View_Result;
import java.awt.Graphics2D;
import main.Listener;
import main.util.BlackOut;
import main.util.DIRECTION;

public class Menu_Result {
    private static boolean flag_enter = false;
    private static boolean flag_item_conservation;
    private static boolean flag_jast_watch_record;
    private static boolean flag_setScene;
    private static Base_Artifact[] present_enchants;
    private static ResultSaveLoad result;
    private static int x;
    private static int y;
    private static final int X_LENGTH;
    private static final int Y_LENGTH = 4;

    static {
        flag_jast_watch_record = false;
        flag_setScene = true;
        present_enchants = new Base_Artifact[Enchant.values().length];
        result = null;
        x = 0;
        y = 0;
        X_LENGTH = 1 + Belongings.getMax() / 10;
    }

    public static synchronized void actionKeyPressed(Listener.ACTION action) {
        if (flag_enter) {
            return;
        }
        if (flag_jast_watch_record && action == Listener.ACTION.CANCEL) {
            action = Listener.ACTION.ENTER;
        }
        if (action == Listener.ACTION.ENTER) {
            flag_enter = true;
            if (flag_jast_watch_record) {
                Menu_Result.enchant_off();
                DangeonScene.SELECT.setPresentScene();
            } else {
                Menu_Result.end();
            }
        }
    }

    public static synchronized void arrowKeyPressed(DIRECTION direction) {
    }

    public static synchronized void draw(Graphics2D g) {
        View_Result.draw(g);
    }

    private static void enchant_off() {
        int i = 0;
        while (i < Enchant.values().length) {
            Enchant.values()[i].setEnchant(present_enchants[i]);
            ++i;
        }
    }

    private static void enchant_on() {
        int i = 0;
        while (i < Enchant.values().length) {
            Menu_Result.present_enchants[i] = Enchant.values()[i].getEnchant();
            Enchant.values()[i].setEnchant(Menu_Result.result.ENCHANT_ARTIFACT[i]);
            ++i;
        }
    }

    private static void end() {
        if (!Player.flag_clear) {
            Config.addTimes();
        }
        BlackOut.setNoMoveSE();
        new BlackOut(new FairyPlace(), new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                DangeonScene.DANGEON.setPresentScene();
                result = null;
                MassCreater mc = new MassCreater(new FairyPlace(), false);
                TaskOnMapObject.setNewMap(mc);
                if (flag_item_conservation) {
                    Player.me.resetAll_exceptItems();
                    Player.flag_clear = false;
                } else {
                    Player.me.resetAll();
                }
                new SaveLoad(mc).saveContinue();
                SaveLoad.delete(true);
            }
        });
    }

    public static int getMaxY() {
        return 4;
    }

    public static ResultSaveLoad getResult() {
        return result;
    }

    public static int getX() {
        return x - 1;
    }

    public static int getY() {
        return y;
    }

    public static void init(ResultSaveLoad rsl) {
        flag_item_conservation = false;
        flag_jast_watch_record = false;
        TaskOnMapObject.clearCheckArtifact();
        flag_enter = false;
        result = rsl;
        Menu_Result.initY();
        x = 0;
        Menu_Result.setScene();
        Menu_Result.enchant_on();
    }

    public static void init(String msg, Base_Map_Random bmr, boolean flag_clear) {
        Player.flag_clear = flag_clear;
        Player.me.cause_of_death = msg;
        flag_setScene = false;
        Menu_Result.init(new ResultSaveLoad(bmr));
        flag_item_conservation = true;
        flag_setScene = true;
    }

    public static void init(String field, int i) {
        flag_jast_watch_record = true;
    }

    private static void initY() {
        y = Menu_Result.result.RECORD.length - 2 - 4 + 1;
        if (y < 0) {
            y = 0;
        }
    }

    public static void setFlagConservation(boolean b) {
        flag_item_conservation = b;
    }

    public static void setScene() {
        if (flag_setScene) {
            DangeonScene.RESULT.setPresentScene();
        }
    }
}

