/*
 * Decompiled with CFR 0.152.
 */
package connection.sv_cl;

import connection.sv_cl.ConnectionSubFrame;
import connection.sv_cl.SocketHolder;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class Server {
    public Server(ConnectionSubFrame connectionSubFrame, int port) throws Exception {
        ServerSocket svsock = new ServerSocket(port);
        try {
            svsock.setSoTimeout(this.getTimeOut());
            SocketHolder.createInstance(connectionSubFrame, svsock.accept(), true);
        }
        catch (Exception e) {
            if (svsock != null) {
                svsock.close();
            }
            throw e;
        }
    }

    public Server(ConnectionSubFrame connectionSubFrame, String hostname, int port) throws Exception {
        Socket sock = new Socket();
        try {
            sock.setSoTimeout(this.getTimeOut());
            sock.connect(new InetSocketAddress(hostname, port));
            SocketHolder.createInstance(connectionSubFrame, sock, false);
        }
        catch (Exception e) {
            if (sock != null) {
                sock.close();
            }
            throw e;
        }
    }

    private int getTimeOut() {
        int sec = 30;
        int milli = 1000;
        return sec * milli;
    }
}

