/*
 * Decompiled with CFR 0.152.
 */
package connection.sv_cl;

import connection.sv_cl.DungeonConverter;
import connection.sv_cl.Server;
import dangeon.model.config.Config;
import dangeon.model.map.PresentField;
import dangeon.model.map.field.random.Base_Map_Random;
import dangeon.model.map.field.town.map.FairyPlace;
import dangeon.model.object.creature.player.Belongings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.SocketTimeoutException;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import main.Second_Firster;

public class ConnectionSubFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static ConnectionSubFrame me;
    private final ComponentHolder component_holder;
    private String[] keys = new String[]{"share_name", "share_host", "share_port"};
    private boolean flag_server_slected = true;

    public static void createInstance() {
        if (me != null) {
            me.dispose();
        }
        me = new ConnectionSubFrame();
    }

    public static void main(String[] args) {
        new ConnectionSubFrame();
    }

    private ConnectionSubFrame() {
        this.setResizable(false);
        this.component_holder = new ComponentHolder();
        this.setLayout(new FlowLayout());
        this.setButtons();
        this.setTitle("\u30b7\u30a7\u30a2\u30a6\u30a3\u30f3\u30c9\u30a6");
        int w = 250;
        int h = 300;
        if (Second_Firster.ME != null) {
            this.setBounds(Second_Firster.ME.getX() - w / 2, Second_Firster.ME.getY(), w, h);
        } else {
            this.setBounds(0, 0, w, h);
        }
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private JComboBox addButtonWithLabel(JPanel p, String string, String ... default_items) {
        JPanel sub = new JPanel();
        int hgap = 10;
        sub.setLayout(new BorderLayout(hgap, 0));
        JLabel l = new JLabel(string);
        JComboBox<String> box = new JComboBox<String>();
        box.setEditable(true);
        String[] stringArray = default_items;
        int n = default_items.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            box.addItem(s);
            ++n2;
        }
        sub.add((Component)l, "West");
        sub.add(box, "Center");
        p.add(sub);
        return box;
    }

    private Component createRadioButtonGroup() {
        JPanel sub = new JPanel();
        this.setBorder(sub, "\u9078\u629e");
        JRadioButton radio1 = new JRadioButton("Server", true);
        JRadioButton radio2 = new JRadioButton("Client", false);
        ChangeListener server_radio_button_listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JRadioButton radio1 = (JRadioButton)e.getSource();
                ConnectionSubFrame.this.swichRadioButton(radio1.isSelected());
            }
        };
        radio1.addChangeListener(server_radio_button_listener);
        ButtonGroup group = new ButtonGroup();
        group.add(radio1);
        group.add(radio2);
        sub.add(radio1);
        sub.add(radio2);
        return sub;
    }

    private Component createSubmitButton() {
        JButton b1 = new JButton("\u63a5\u7d9a");
        this.component_holder.addSubmitButton(b1);
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionSubFrame.this.submit();
            }
        });
        return b1;
    }

    private Component createTextFields() {
        JPanel p = new JPanel();
        this.component_holder.addNameField(this.addButtonWithLabel(p, "NAME", this.getDefault(this.keys[0])));
        this.component_holder.addHostField(this.addButtonWithLabel(p, "HOST", this.getDefault(this.keys[1])));
        this.component_holder.host_field.setEnabled(false);
        this.component_holder.addPortField(this.addButtonWithLabel(p, "PORT", this.getDefault(this.keys[2])));
        this.component_holder.addDungeonField(this.addButtonWithLabel(p, "TO... ", this.getDefaultDungeon()));
        this.component_holder.dungeon_field.setEditable(false);
        return p;
    }

    private String[] getDefault(String key) {
        Object val = Config.getValue(key);
        if (val == null) {
            return new String[]{""};
        }
        return val.toString().split(",");
    }

    private String[] getDefaultDungeon() {
        return new DungeonConverter().getDefaultDungeonName();
    }

    public String getDungeon() {
        return this.component_holder.dungeon_field.getSelectedItem().toString();
    }

    @Override
    public String getName() {
        return this.component_holder.name_field.getSelectedItem().toString();
    }

    private void saveItems() {
        JComboBox[] boxes = new JComboBox[]{this.component_holder.name_field, this.component_holder.host_field, this.component_holder.port_field};
        int i = 0;
        while (i < boxes.length) {
            JComboBox box = boxes[i];
            StringBuilder sb = new StringBuilder();
            String selected = box.getSelectedItem().toString();
            sb.append(selected);
            ComboBoxModel model = box.getModel();
            int size = model.getSize();
            int j = 0;
            while (j < size) {
                Object element = model.getElementAt(j);
                if (!selected.equals(element.toString())) {
                    sb.append(",");
                    sb.append(element.toString());
                }
                ++j;
            }
            Config.saveValue(this.keys[i], sb.toString());
            ++i;
        }
    }

    private void setBorder(JPanel sub, String title) {
        TitledBorder border = new TitledBorder(title);
        sub.setBorder(border);
    }

    private void setButtons() {
        this.setLayout(new BorderLayout());
        this.add(this.createRadioButtonGroup(), "North");
        this.add(this.createTextFields(), "Center");
        this.add(this.createSubmitButton(), "South");
    }

    private void submit() {
        String[] arr;
        if (!PresentField.get().getClass().equals(FairyPlace.class)) {
            JOptionPane.showMessageDialog(this, "\u5996\u7cbe\u306e\u8e0a\u308a\u5834\u304b\u3089\u63a5\u7d9a\u3057\u3066\u4e0b\u3055\u3044");
            return;
        }
        if (!this.flag_server_slected) {
            if (!Belongings.isEmpty()) {
                JOptionPane.showMessageDialog(this, "\u30a2\u30a4\u30c6\u30e0\u306f\u6301\u3061\u8fbc\u3081\u307e\u305b\u3093");
                return;
            }
        } else {
            Base_Map_Random map = new DungeonConverter().inflate(this.getDungeon());
            if (map.ITEM_MAX != null && Belongings.getSize() > map.ITEM_MAX) {
                JOptionPane.showMessageDialog(this, "\u30a2\u30a4\u30c6\u30e0\u6301\u3061\u8fbc\u307f\u4e0a\u9650\u6570\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                return;
            }
        }
        String name = this.component_holder.name_field.getSelectedItem().toString();
        String host = this.flag_server_slected ? "0" : this.component_holder.host_field.getSelectedItem().toString();
        String port = this.component_holder.port_field.getSelectedItem().toString();
        String[] stringArray = arr = new String[]{name, host, port};
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string == null || string.trim().isEmpty()) {
                JOptionPane.showMessageDialog(this, "\u5165\u529b\u9805\u76ee\u304c\u8db3\u308a\u307e\u305b\u3093");
                return;
            }
            ++n2;
        }
        int port_int = 0;
        try {
            port_int = Integer.parseInt(port);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "PORT\u306b\u306f\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044");
            return;
        }
        if (port_int < 1024 || port_int > 65535) {
            JOptionPane.showMessageDialog(this, "1024 \uff5e 65535 \u306e\u6574\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044.");
            return;
        }
        try {
            if (this.flag_server_slected) {
                new Server(this, port_int);
            } else {
                new Server(this, host, port_int);
            }
            this.saveItems();
            this.dispose();
        }
        catch (SocketTimeoutException e) {
            JOptionPane.showMessageDialog(this, "\u63a5\u7d9a\u304c\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f.");
            e.printStackTrace();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, "\u30dd\u30fc\u30c8\u306e\u78ba\u4fdd\u306b\u5931\u6557\u3057\u307e\u3057\u305f.\u5225\u306e\u5024\u3092\u304a\u8a66\u3057\u4e0b\u3055\u3044");
            e1.printStackTrace();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this, "\u4e88\u671f\u3057\u306a\u3044\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            e2.printStackTrace();
        }
    }

    private void swichRadioButton(boolean server_selected) {
        this.flag_server_slected = server_selected;
        this.component_holder.host_field.setEnabled(!server_selected);
        this.component_holder.dungeon_field.setEnabled(server_selected);
    }

    private class ComponentHolder {
        private JButton submit_button;
        private JComboBox name_field;
        private JComboBox port_field;
        private JComboBox host_field;
        private JComboBox dungeon_field;

        private ComponentHolder() {
        }

        public void addDungeonField(JComboBox c) {
            this.dungeon_field = c;
        }

        public void addHostField(JComboBox c) {
            this.host_field = c;
        }

        public void addNameField(JComboBox c) {
            this.name_field = c;
        }

        public void addPortField(JComboBox c) {
            this.port_field = c;
        }

        public void addSubmitButton(JButton b1) {
            this.submit_button = b1;
        }
    }
}

