/*
 * Decompiled with CFR 0.152.
 */
package connection.sv_cl;

import connection.sv_cl.ImagenPerso;
import connection.sv_cl.SocketHolder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import main.thread.MainThread;

public class CommunicationSubFrame
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static CommunicationSubFrame me;
    private int w;
    private int h;
    private JPanel panel_lv2;
    private JLabel label;
    private JButton button;
    private String identifiler = "@@";
    private final int myself = 0;
    private final int opponent = 1;
    private final int system = 2;
    private String[] names = new String[]{"\u81ea\u5206", "\u76f8\u624b", "\uff0a\uff0a"};
    private Color[] colors = new Color[]{Color.WHITE, Color.YELLOW, Color.GREEN};
    private JTextField input_field;
    private JScrollPane scrollPane;
    private Color scroll_pain_color = new Color(0, 0, 0, 200);
    JTextPane text_pane = new JTextPane();
    private DefaultStyledDocument document;
    private boolean flag_end = false;

    public static CommunicationSubFrame create(int x, int y) {
        if (me != null) {
            me.dispose();
        }
        me = new CommunicationSubFrame(x, y);
        return me;
    }

    public static void main(String[] args) {
        new CommunicationSubFrame(0, 0);
    }

    private CommunicationSubFrame(int x, int y) {
        this.setResizable(false);
        this.setTitle("\u30b7\u30a7\u30a2\u30a6\u30a3\u30f3\u30c9\u30a6");
        this.setVisible(true);
        Insets i = this.getInsets();
        int insets_w = i.left + i.right;
        int insets_h = i.bottom + i.top;
        this.w = 400;
        this.h = 360;
        this.setBounds(x, y, this.w + insets_w, this.h + insets_h);
        this.setButtons();
        this.setDefaultCloseOperation(3);
        new Thread(this).start();
    }

    private void addMouseListener(Component layered_pane) {
        MouseListener l = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CommunicationSubFrame.this.panel_lv2.setVisible(false);
                CommunicationSubFrame.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CommunicationSubFrame.this.panel_lv2.setVisible(true);
                CommunicationSubFrame.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseExited(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouseExited(e);
            }
        };
        layered_pane.addMouseListener(l);
        this.text_pane.addMouseListener(l);
    }

    private void appendDisplay(String msg, int who) {
        if (msg != null) {
            SimpleAttributeSet attribute = new SimpleAttributeSet();
            attribute.addAttribute(StyleConstants.Foreground, this.colors[who]);
            try {
                msg = String.valueOf(this.names[who]) + "\uff1a" + msg + "\n";
                this.document.insertString(this.document.getLength(), msg, attribute);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            JViewport view = this.scrollPane.getViewport();
            view.setViewPosition(new Point(0, this.text_pane.getHeight()));
            this.repaint();
        }
    }

    private Component createInputField() {
        this.input_field = new JTextField();
        this.input_field.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CommunicationSubFrame.this.submit();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        return this.input_field;
    }

    private Component createLabel() {
        this.label = new JLabel();
        this.label.setBackground(Color.BLACK);
        this.label.setOpaque(true);
        this.label.setBounds(0, 0, 400, 340);
        return this.label;
    }

    private Component createList() {
        this.text_pane.setBackground(new Color(0, 0, 0, 0));
        this.text_pane.setOpaque(true);
        this.text_pane.setEditable(false);
        this.scrollPane = new JScrollPane(this.text_pane);
        this.document = new DefaultStyledDocument();
        this.text_pane.setDocument(this.document);
        this.scrollPane.setBackground(this.scroll_pain_color);
        return this.scrollPane;
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        return panel;
    }

    private Component createPanelLv2() {
        this.panel_lv2 = new JPanel();
        this.panel_lv2.setOpaque(false);
        this.panel_lv2.setLayout(new BorderLayout());
        JPanel sub_panel_center = this.createPanel();
        sub_panel_center.setOpaque(false);
        sub_panel_center.add(this.createList(), "Center");
        sub_panel_center.add(this.createInputField(), "South");
        JPanel sub_panel_east = this.createPanel();
        sub_panel_east.setOpaque(false);
        sub_panel_east.add(this.createSubmitButton(), "South");
        this.panel_lv2.add((Component)sub_panel_center, "Center");
        this.panel_lv2.add((Component)sub_panel_east, "East");
        this.panel_lv2.setBounds(0, 0, this.w, this.h);
        return this.panel_lv2;
    }

    private Component createSubmitButton() {
        this.button = new JButton("\u9001\u4fe1");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommunicationSubFrame.this.submit();
            }
        });
        return this.button;
    }

    @Override
    public void dispose() {
        me = null;
        super.dispose();
    }

    public void end() {
        this.flag_end = true;
        this.dispose();
    }

    public void recieve(String msg) {
        if (msg.startsWith(this.identifiler)) {
            this.appendDisplay(msg.substring(this.identifiler.length()), 1);
        } else {
            this.appendDisplay(msg, 2);
        }
    }

    @Override
    public void run() {
        while (!this.flag_end) {
            this.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private void screenshot() {
        String first = String.valueOf(this.identifiler) + "\uff08\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u9001\u4fe1\uff09";
        BufferedImage im = MainThread.ME.getScreenShot();
        String end = String.valueOf(this.identifiler) + "\uff08\u9001\u4fe1\u5b8c\u4e86\uff09";
        this.appendDisplay(first.substring(this.identifiler.length()), 0);
        SocketHolder.submit(new Serializable[]{first, new ImagenPerso(im), end});
        this.appendDisplay(end.substring(this.identifiler.length()), 0);
    }

    public void setBackground(BufferedImage image) {
        ImageIcon icon = new ImageIcon(image);
        this.label.setIcon(icon);
    }

    private void setButtons() {
        JLayeredPane layered_pane = new JLayeredPane();
        this.setContentPane(layered_pane);
        layered_pane.add(this.createPanelLv2(), JLayeredPane.DEFAULT_LAYER);
        layered_pane.add(this.createLabel(), JLayeredPane.DEFAULT_LAYER);
        this.addMouseListener(layered_pane);
    }

    private void submit() {
        String msg = this.input_field.getText();
        if (msg == null || msg.isEmpty()) {
            this.screenshot();
        } else {
            this.input_field.setText("");
            SocketHolder.submit(String.valueOf(this.identifiler) + msg);
            this.appendDisplay(msg, 0);
        }
    }

    public void warning(String string) {
        JOptionPane.showMessageDialog(this, string);
    }
}

