/*
 * Decompiled with CFR 0.152.
 */
package cirno_question.maptool;

import cirno_question.QS;
import cirno_question.maptool.MapFrame;
import cirno_question.maptool.MapMass;
import cirno_question.maptool.MassCategory;
import cirno_question.maptool.map_button.ButtonClear;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class MainMap {
    public static MainMap ME = new MainMap();
    public final int MAX_MASS_X = 40;
    public final int MAX_MASS_Y = 30;
    public final int MASS_DIAMETER = 15;
    private MapMass[][] mass = new MapMass[40][30];

    public void allClear() {
        int i = 0;
        while (i < 40) {
            int j = 0;
            while (j < 30) {
                this.mass[i][j].massClear();
                ++j;
            }
            ++i;
        }
    }

    public Point checkMousePointIntoMassPoint(Point p) {
        return new Point(p.x / 15, p.y / 15);
    }

    public MapMass[][] getAllMass() {
        return this.mass;
    }

    public MapMass getMass(int x, int y) {
        if (x >= 40 || y >= 30) {
            return null;
        }
        if (x < 0 || y < 0) {
            return null;
        }
        return this.mass[x][y];
    }

    public MapMass getMass(Point point) {
        Point p = this.checkMousePointIntoMassPoint(point);
        if (p.x >= 40 || p.y >= 30) {
            return null;
        }
        if (p.x < 0 || p.y < 0) {
            return null;
        }
        return this.mass[p.x][p.y];
    }

    public boolean isEnterExit() {
        boolean enter = false;
        boolean exit = false;
        int i = 0;
        while (i < 40) {
            int j = 0;
            while (j < 30) {
                if (this.mass[i][j].isEnter()) {
                    enter = true;
                } else if (this.mass[i][j].isExit()) {
                    exit = true;
                }
                if (enter && exit) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isOutMassLine(Point p) {
        return p.x <= 0 || p.y <= 0 || p.x >= 39 || p.y >= 29;
    }

    public void setFirstMass() {
        int i = 0;
        while (i < 40) {
            int j = 0;
            while (j < 30) {
                this.mass[i][j] = new MapMass(MassCategory.WALKABLE, i, j);
                ++j;
            }
            ++i;
        }
    }

    public void setMassCategory(MouseEvent e) {
        if (this.isOutMassLine(this.checkMousePointIntoMassPoint(e.getPoint()))) {
            return;
        }
        if (e.getPoint().x >= 600 || e.getPoint().y >= 450) {
            return;
        }
        MapMass mm = this.getMass(e.getPoint());
        int i = 0;
        while (i <= MapFrame.ME.bounds_box.getSelectedIndex()) {
            int j = 0;
            while (j <= MapFrame.ME.bounds_box.getSelectedIndex()) {
                MapMass _m = this.getMass(mm.getX() + i, mm.getY() + j);
                if (_m != null) {
                    if (QS.map_clip_category == null && QS.map_clip_object == null) {
                        ButtonClear.massClear(_m);
                    } else if (QS.map_clip_category == null) {
                        _m.setMassObject(QS.map_clip_object);
                    } else {
                        _m.setMassCategory(QS.map_clip_category);
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

