/*
 * Decompiled with CFR 0.152.
 */
package cirno_question.frame;

import cirno_question.maptool.MainMap;
import cirno_question.maptool.MapMass;
import cirno_question.maptool.MassCategory;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class MapPanel
extends JPanel {
    private static final long serialVersionUID = -9007671475796050945L;

    @Override
    public void paintComponent(Graphics g) {
        this.paintStrings(g);
        g.setColor(Color.DARK_GRAY);
        int i = 0;
        while (i <= 450) {
            g.drawLine(0, i, 600, i);
            i += 15;
        }
        i = 0;
        while (i <= 600) {
            g.drawLine(i, 0, i, 450);
            i += 15;
        }
    }

    public void paintFillMassCategory(Graphics g, MapMass mm) {
        if (MainMap.ME.isOutMassLine(mm.getMassPoint())) {
            return;
        }
        if (mm.getMassCategory() == MassCategory.WALKABLE) {
            g.setColor(Color.black);
        } else if (mm.getMassCategory() == MassCategory.ROAD) {
            g.setColor(Color.LIGHT_GRAY);
        } else if (mm.getMassCategory() == MassCategory.ROOM) {
            g.setColor(Color.WHITE);
        } else if (mm.getMassCategory() == MassCategory.WATER) {
            g.setColor(Color.BLUE);
        } else {
            g.setColor(Color.DARK_GRAY);
        }
        g.fillRect(15 * mm.getX(), 15 * mm.getY(), 15, 15);
    }

    public void paintStringMassObject(Graphics g, MapMass mm) {
        if (mm.getListMapObject().isEmpty()) {
            return;
        }
        if (mm.isEnemy()) {
            g.setColor(Color.red);
            if (mm.isItem() || mm.isTrap() || mm.isEnter() || mm.isExit()) {
                g.fillRect(15 * mm.getX() + 3, 15 * mm.getY() + 3, 10, 5);
            } else {
                g.fillRect(15 * mm.getX() + 3, 15 * mm.getY() + 3, 10, 10);
            }
            if (mm.EM.sleep) {
                g.setColor(Color.cyan);
                g.fillRect(15 * mm.getX() + 4, 15 * mm.getY() + 4, 4, 4);
            }
            if (mm.EM.angry) {
                g.setColor(Color.BLUE);
                g.fillRect(15 * mm.getX() + 8, 15 * mm.getY() + 4, 4, 4);
            }
        }
        if (mm.isItem() || mm.isTrap() || mm.isEnter() || mm.isExit()) {
            if (mm.isItem()) {
                g.setColor(Color.green);
            } else if (mm.isTrap()) {
                g.setColor(Color.yellow);
            } else if (mm.isEnter()) {
                g.setColor(Color.ORANGE);
            } else {
                g.setColor(Color.PINK);
            }
            if (mm.isEnemy()) {
                g.fillRect(15 * mm.getX() + 3, 15 * mm.getY() + 8, 10, 5);
            } else {
                g.fillRect(15 * mm.getX() + 3, 15 * mm.getY() + 3, 10, 10);
            }
            g.setColor(Color.blue);
        }
    }

    public void paintStrings(Graphics g) {
        int i = 0;
        while (i < MainMap.ME.MAX_MASS_X) {
            int j = 0;
            while (j < MainMap.ME.MAX_MASS_Y) {
                MapMass mm = MainMap.ME.getMass(i, j);
                this.paintFillMassCategory(g, mm);
                this.paintStringMassObject(g, mm);
                ++j;
            }
            ++i;
        }
    }
}

